/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.particles.itemparticle;

import com.direwolf20.laserio.client.particles.ModParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemFlowParticleData
implements ParticleOptions {
    private final ItemStack itemStack;
    protected final double targetX;
    protected final double targetY;
    protected final double targetZ;
    protected final int ticksPerBlock;
    public static final ParticleOptions.Deserializer<ItemFlowParticleData> DESERIALIZER = new ParticleOptions.Deserializer<ItemFlowParticleData>(){

        @Nonnull
        public ItemFlowParticleData fromCommand(ParticleType<ItemFlowParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            ItemParser.ItemResult itemparser$itemresult = ItemParser.m_235305_((HolderLookup)BuiltInRegistries.f_257033_.m_255303_(), (StringReader)reader);
            ItemStack itemstack = new ItemInput(itemparser$itemresult.f_235328_(), itemparser$itemresult.f_235329_()).m_120980_(1, false);
            reader.expect(' ');
            double tx = reader.readDouble();
            reader.expect(' ');
            double ty = reader.readDouble();
            reader.expect(' ');
            double tz = reader.readDouble();
            reader.expect(' ');
            int ticks = reader.readInt();
            return new ItemFlowParticleData(itemstack, tx, ty, tz, ticks);
        }

        public ItemFlowParticleData fromNetwork(ParticleType<ItemFlowParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            return new ItemFlowParticleData(buffer.m_130267_(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readInt());
        }
    };

    public ItemFlowParticleData(ItemStack itemStack, double tx, double ty, double tz, int ticks) {
        this.itemStack = itemStack.m_41777_();
        this.targetX = tx;
        this.targetY = ty;
        this.targetZ = tz;
        this.ticksPerBlock = ticks;
    }

    @Nonnull
    public ParticleType<ItemFlowParticleData> m_6012_() {
        return (ParticleType)ModParticles.ITEM_FLOW_PARTICLE.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeItemStack(this.itemStack, false);
        buffer.writeDouble(this.targetX);
        buffer.writeDouble(this.targetY);
        buffer.writeDouble(this.targetZ);
        buffer.writeInt(this.ticksPerBlock);
    }

    @Nonnull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %.2f %s", this.m_6012_(), this.targetX, this.targetY, this.targetZ, this.ticksPerBlock);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItemStack() {
        return this.itemStack;
    }
}

