/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.jei;

import com.direwolf20.laserio.client.jei.GhostIngredientHandler;
import com.direwolf20.laserio.client.jei.GuiContainerHandler;
import com.direwolf20.laserio.client.screens.CardEnergyScreen;
import com.direwolf20.laserio.client.screens.CardItemScreen;
import com.direwolf20.laserio.client.screens.FilterBasicScreen;
import com.direwolf20.laserio.client.screens.FilterCountScreen;
import com.direwolf20.laserio.client.screens.FilterNBTScreen;
import com.direwolf20.laserio.client.screens.FilterTagScreen;
import com.direwolf20.laserio.client.screens.LaserNodeScreen;
import com.direwolf20.laserio.integration.mekanism.MekanismIntegration;
import com.direwolf20.laserio.setup.Registration;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.registries.RegistryObject;

@JeiPlugin
public class JEIIntegration
implements IModPlugin {
    @Nonnull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("laserio", "jei_plugin");
    }

    private void addHiddenRecipe(List<CraftingRecipe> hiddenRecipes, RecipeManager recipeManager, RegistryObject<Item> itemRegistry) {
        hiddenRecipes.add((CraftingRecipe)recipeManager.m_44043_(itemRegistry.getId().m_266382_("_nbtclear")).get());
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        IRecipeManager recipeRegistry = jeiRuntime.getRecipeManager();
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        ArrayList<CraftingRecipe> hiddenRecipes = new ArrayList<CraftingRecipe>();
        this.addHiddenRecipe(hiddenRecipes, recipeManager, Registration.CARD_ITEM);
        this.addHiddenRecipe(hiddenRecipes, recipeManager, Registration.CARD_FLUID);
        this.addHiddenRecipe(hiddenRecipes, recipeManager, Registration.CARD_ENERGY);
        this.addHiddenRecipe(hiddenRecipes, recipeManager, Registration.CARD_REDSTONE);
        if (MekanismIntegration.isLoaded()) {
            this.addHiddenRecipe(hiddenRecipes, recipeManager, Registration.CARD_CHEMICAL);
        }
        this.addHiddenRecipe(hiddenRecipes, recipeManager, Registration.FILTER_BASIC);
        this.addHiddenRecipe(hiddenRecipes, recipeManager, Registration.FILTER_COUNT);
        this.addHiddenRecipe(hiddenRecipes, recipeManager, Registration.FILTER_TAG);
        this.addHiddenRecipe(hiddenRecipes, recipeManager, Registration.FILTER_NBT);
        this.addHiddenRecipe(hiddenRecipes, recipeManager, Registration.FILTER_MOD);
        recipeRegistry.hideRecipes(RecipeTypes.CRAFTING, hiddenRecipes);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(LaserNodeScreen.class, new GuiContainerHandler());
        registration.addGuiContainerHandler(CardItemScreen.class, new GuiContainerHandler());
        registration.addGuiContainerHandler(CardEnergyScreen.class, new GuiContainerHandler());
        registration.addGhostIngredientHandler(CardItemScreen.class, new GhostIngredientHandler());
        registration.addGhostIngredientHandler(FilterBasicScreen.class, new GhostIngredientHandler());
        registration.addGhostIngredientHandler(FilterCountScreen.class, new GhostIngredientHandler());
        registration.addGhostIngredientHandler(FilterNBTScreen.class, new GhostIngredientHandler());
        registration.addGhostIngredientHandler(FilterTagScreen.class, new GhostIngredientHandler());
    }
}

