/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.events;

import com.direwolf20.laserio.client.events.RenderGUIOverlay;
import com.direwolf20.laserio.client.renderer.BlockOverlayRender;
import com.direwolf20.laserio.client.renderer.DelayedRenderer;
import com.direwolf20.laserio.common.blockentities.LaserConnectorAdvBE;
import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.common.blockentities.basebe.BaseLaserBE;
import com.direwolf20.laserio.common.blocks.LaserConnectorAdv;
import com.direwolf20.laserio.common.items.CardCloner;
import com.direwolf20.laserio.common.items.LaserWrench;
import com.direwolf20.laserio.setup.Config;
import com.direwolf20.laserio.util.DimBlockPos;
import com.direwolf20.laserio.util.VectorHelper;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;

public class ClientEvents {
    public static final boolean IS_OCULUS_LOADED = ModList.get().isLoaded("oculus");
    private static final RenderLevelStageEvent.Stage RENDERING_STAGE = IS_OCULUS_LOADED ? RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS : RenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS;

    @SubscribeEvent
    static void renderWorldLastEvent(RenderLevelStageEvent evt) {
        CompoundTag copiedNodeTag;
        ItemStack cardCloner;
        BlockPos selectedPos;
        BlockEntity selectedBE;
        DimBlockPos selectedDimPos;
        if (evt.getStage() != RENDERING_STAGE) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Level level = player.m_9236_();
        ResourceKey dimension = level.m_46472_();
        ItemStack wrench = ClientEvents.findWrench((Player)player);
        if (!wrench.m_41619_() && (selectedDimPos = LaserWrench.getConnectionPos(wrench, level)) != null && dimension.equals(selectedDimPos.levelKey) && (selectedBE = level.m_7702_(selectedPos = selectedDimPos.blockPos)) instanceof BaseLaserBE) {
            BaseLaserBE baseLaserBE = (BaseLaserBE)selectedBE;
            BlockOverlayRender.renderSelectedBlock(evt, selectedPos, baseLaserBE, Color.GREEN);
        }
        if (!(cardCloner = ClientEvents.findCardHolder((Player)player)).m_41619_() && !(copiedNodeTag = CardCloner.getNodeData(cardCloner)).m_128456_()) {
            BlockPos copiedNodePos;
            BlockEntity copiedNodeBE;
            String copiedNodeDim = copiedNodeTag.m_128461_("dimension");
            if (dimension.m_135782_().m_214299_().equals(copiedNodeDim) && (copiedNodeBE = level.m_7702_(copiedNodePos = NbtUtils.m_129239_((CompoundTag)copiedNodeTag.m_128469_("myWorldPos")))) instanceof LaserNodeBE) {
                LaserNodeBE laserNodeBE = (LaserNodeBE)copiedNodeBE;
                BlockOverlayRender.renderSelectedBlock(evt, copiedNodePos, laserNodeBE, Color.CYAN);
            }
        }
        DelayedRenderer.render(evt.getPoseStack());
        DelayedRenderer.renderConnections(evt.getPoseStack());
    }

    public static ItemStack findItemInHands(Player player, Class<? extends Item> itemClass) {
        ItemStack heldItem = player.m_21205_();
        if (!itemClass.isInstance(heldItem.m_41720_()) && !itemClass.isInstance((heldItem = player.m_21206_()).m_41720_())) {
            return ItemStack.f_41583_;
        }
        return heldItem;
    }

    public static ItemStack findWrench(Player player) {
        return ClientEvents.findItemInHands(player, LaserWrench.class);
    }

    public static ItemStack findCardHolder(Player player) {
        return ClientEvents.findItemInHands(player, CardCloner.class);
    }

    @SubscribeEvent
    static void renderGUIOverlay(CustomizeGuiOverlayEvent.DebugText evt) {
        BlockPos blockPos;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (ClientEvents.findWrench((Player)player).m_41619_()) {
            return;
        }
        BlockHitResult lookingAt = VectorHelper.getLookingAt((Player)player, ClipContext.Fluid.NONE, (int)((Integer)Config.MAX_INTERACTION_RANGE.get()));
        if (lookingAt == null) {
            return;
        }
        Level level = player.m_9236_();
        if (!(level.m_8055_(blockPos = lookingAt.m_82425_()).m_60734_() instanceof LaserConnectorAdv)) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof LaserConnectorAdvBE) {
            LaserConnectorAdvBE laserConnectorAdvBE = (LaserConnectorAdvBE)blockEntity;
            GuiGraphics guiGraphics = evt.getGuiGraphics();
            Font font = Minecraft.m_91087_().f_91062_;
            RenderGUIOverlay.renderLocation(font, guiGraphics, laserConnectorAdvBE);
        }
    }
}

