/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.blockentityrenders;

import com.direwolf20.laserio.client.blockentityrenders.baseberender.BaseLaserBERender;
import com.direwolf20.laserio.client.renderer.DelayedRenderer;
import com.direwolf20.laserio.common.blockentities.LaserConnectorAdvBE;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public class LaserConnectorAdvBERender
extends BaseLaserBERender<LaserConnectorAdvBE> {
    public LaserConnectorAdvBERender(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public void render(LaserConnectorAdvBE blockentity, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightsIn, int combinedOverlayIn) {
        long gameTime = blockentity.m_58904_().m_46467_();
        if (blockentity.getPartnerDimBlockPos() != null) {
            Matrix4f matrix4f = matrixStackIn.m_85850_().m_252922_();
            this.renderCube(blockentity, matrix4f, bufferIn.m_6299_(this.renderType()), gameTime, partialTicks);
            DelayedRenderer.add(blockentity);
        } else {
            super.render(blockentity, partialTicks, matrixStackIn, bufferIn, combinedLightsIn, combinedOverlayIn);
        }
    }

    private void renderCube(LaserConnectorAdvBE blockEntity, Matrix4f matrixStack, VertexConsumer vertexConsumer, long gameTime, float partialTicks) {
        float one;
        float zero;
        Direction direction = ((Direction)blockEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)).m_122424_();
        float oneSmall = 0.53125f;
        float zeroSmall = 0.46875f;
        float oneBig = 0.5625f;
        float zeroBig = 0.4375f;
        int ticks = 80;
        float f1 = (float)Math.floorMod(gameTime, ticks) + partialTicks;
        float lerp = f1 / (float)ticks;
        if (f1 < (float)ticks / 2.0f) {
            zero = Mth.m_14179_((float)lerp, (float)zeroSmall, (float)zeroBig);
            one = Mth.m_14179_((float)lerp, (float)oneSmall, (float)oneBig);
        } else {
            zero = Mth.m_14179_((float)lerp, (float)zeroBig, (float)zeroSmall);
            one = Mth.m_14179_((float)lerp, (float)oneBig, (float)oneSmall);
        }
        float diff = one - zero;
        switch (direction) {
            case UP: {
                float f = 0.75f;
                this.renderFace(matrixStack, vertexConsumer, zero, one, f, f + diff, one, one, one, one);
                this.renderFace(matrixStack, vertexConsumer, zero, one, f + diff, f, zero, zero, zero, zero);
                this.renderFace(matrixStack, vertexConsumer, one, one, f + diff, f, zero, one, one, zero);
                this.renderFace(matrixStack, vertexConsumer, zero, zero, f, f + diff, zero, one, one, zero);
                this.renderFace(matrixStack, vertexConsumer, zero, one, f, f, zero, zero, one, one);
                this.renderFace(matrixStack, vertexConsumer, zero, one, f + diff, f + diff, one, one, zero, zero);
                break;
            }
            case DOWN: {
                float f = 0.25f;
                this.renderFace(matrixStack, vertexConsumer, zero, one, f, f - diff, one, one, one, one);
                this.renderFace(matrixStack, vertexConsumer, zero, one, f - diff, f, zero, zero, zero, zero);
                this.renderFace(matrixStack, vertexConsumer, one, one, f - diff, f, zero, one, one, zero);
                this.renderFace(matrixStack, vertexConsumer, zero, zero, f, f - diff, zero, one, one, zero);
                this.renderFace(matrixStack, vertexConsumer, zero, one, f, f, zero, zero, one, one);
                this.renderFace(matrixStack, vertexConsumer, zero, one, f - diff, f - diff, one, one, zero, zero);
                break;
            }
            case NORTH: {
                float f = 0.25f;
                this.renderFace(matrixStack, vertexConsumer, zero, one, zero, one, f, f, f, f);
                this.renderFace(matrixStack, vertexConsumer, zero, one, one, zero, f - diff, f - diff, f - diff, f - diff);
                this.renderFace(matrixStack, vertexConsumer, one, one, one, zero, f - diff, f, f, f - diff);
                this.renderFace(matrixStack, vertexConsumer, zero, zero, zero, one, f - diff, f, f, f - diff);
                this.renderFace(matrixStack, vertexConsumer, zero, one, zero, zero, f - diff, f - diff, f, f);
                this.renderFace(matrixStack, vertexConsumer, zero, one, one, one, f, f, f - diff, f - diff);
                break;
            }
            case SOUTH: {
                float f = 0.75f;
                this.renderFace(matrixStack, vertexConsumer, zero, one, zero, one, f, f, f, f);
                this.renderFace(matrixStack, vertexConsumer, zero, one, one, zero, f + diff, f + diff, f + diff, f + diff);
                this.renderFace(matrixStack, vertexConsumer, zero, zero, zero, one, f + diff, f, f, f + diff);
                this.renderFace(matrixStack, vertexConsumer, one, one, one, zero, f + diff, f, f, f + diff);
                this.renderFace(matrixStack, vertexConsumer, zero, one, one, one, f, f, f + diff, f + diff);
                this.renderFace(matrixStack, vertexConsumer, zero, one, zero, zero, f + diff, f + diff, f, f);
                break;
            }
            case EAST: {
                float f = 0.75f;
                this.renderFace(matrixStack, vertexConsumer, f, f + diff, zero, one, one, one, one, one);
                this.renderFace(matrixStack, vertexConsumer, f, f + diff, one, zero, zero, zero, zero, zero);
                this.renderFace(matrixStack, vertexConsumer, f + diff, f + diff, one, zero, zero, one, one, zero);
                this.renderFace(matrixStack, vertexConsumer, f, f, zero, one, zero, one, one, zero);
                this.renderFace(matrixStack, vertexConsumer, f, f + diff, zero, zero, zero, zero, one, one);
                this.renderFace(matrixStack, vertexConsumer, f, f + diff, one, one, one, one, zero, zero);
                break;
            }
            case WEST: {
                float f = 0.25f;
                this.renderFace(matrixStack, vertexConsumer, f, f - diff, zero, one, one, one, one, one);
                this.renderFace(matrixStack, vertexConsumer, f, f - diff, one, zero, zero, zero, zero, zero);
                this.renderFace(matrixStack, vertexConsumer, f, f, zero, one, zero, one, one, zero);
                this.renderFace(matrixStack, vertexConsumer, f - diff, f - diff, one, zero, zero, one, one, zero);
                this.renderFace(matrixStack, vertexConsumer, f, f - diff, one, one, one, one, zero, zero);
                this.renderFace(matrixStack, vertexConsumer, f, f - diff, zero, zero, zero, zero, one, one);
            }
        }
    }

    private void renderFace(Matrix4f matrixStack, VertexConsumer vertexConsumer, float x1, float x2, float y1, float y2, float z1, float z2, float z3, float z4) {
        vertexConsumer.m_252986_(matrixStack, x1, y1, z1).m_5752_();
        vertexConsumer.m_252986_(matrixStack, x2, y1, z2).m_5752_();
        vertexConsumer.m_252986_(matrixStack, x2, y2, z3).m_5752_();
        vertexConsumer.m_252986_(matrixStack, x1, y2, z4).m_5752_();
    }

    protected RenderType renderType() {
        return RenderType.m_173239_();
    }
}

