/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.colossalchests.RegistryEntries;
import org.cyclops.colossalchests.blockentity.BlockEntityUncolossalChest;
import org.cyclops.cyclopscore.block.BlockWithEntityGui;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;

public class UncolossalChest
extends BlockWithEntityGui
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);

    public UncolossalChest(BlockBehaviour.Properties properties) {
        super(properties, BlockEntityUncolossalChest::new);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? UncolossalChest.m_152132_(blockEntityType, RegistryEntries.BLOCK_ENTITY_UNCOLOSSAL_CHEST, BlockEntityUncolossalChest::lidAnimateTick) : null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{WATERLOGGED});
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasCustomBreakingProgress(BlockState p_190946_1_) {
        return true;
    }

    public BlockState m_7417_(BlockState blockState, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(blockState, facing, facingState, world, currentPos, facingPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockItemUseContext) {
        Direction facing = blockItemUseContext.m_8125_().m_122424_();
        return (BlockState)super.m_5573_(blockItemUseContext).m_61124_((Property)FACING, (Comparable)facing);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntityUncolossalChest tile;
        super.m_6402_(world, pos, state, placer, stack);
        if (stack.m_41788_() && (tile = (BlockEntityUncolossalChest)BlockEntityHelpers.get((BlockGetter)world, (BlockPos)pos, BlockEntityUncolossalChest.class).orElse(null)) != null) {
            tile.setCustomName(stack.m_41786_());
        }
    }

    public void m_213897_(BlockState blockState, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BlockEntityUncolossalChest) {
            BlockEntityUncolossalChest uncolossalChest = (BlockEntityUncolossalChest)blockEntity;
            uncolossalChest.recheckOpen();
        }
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockStateNew, boolean p_60519_) {
        if (!blockState.m_60713_(blockStateNew.m_60734_())) {
            BlockEntityHelpers.get((BlockGetter)level, (BlockPos)blockPos, BlockEntityUncolossalChest.class).ifPresent(blockEntity -> {
                Containers.m_19002_((Level)level, (BlockPos)blockPos, (Container)blockEntity.getInventory());
                level.m_46717_(blockPos, (Block)this);
            });
            super.m_6810_(blockState, level, blockPos, blockStateNew, p_60519_);
        }
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    public boolean m_7278_(BlockState blockState) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level world, BlockPos pos) {
        return BlockEntityHelpers.get((BlockGetter)world, (BlockPos)pos, BlockEntityUncolossalChest.class).map(tile -> AbstractContainerMenu.m_38938_((Container)tile.getInventory())).orElse(0);
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return blockState.m_60717_(mirror.m_54846_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public boolean m_7357_(BlockState p_196266_1_, BlockGetter p_196266_2_, BlockPos p_196266_3_, PathComputationType p_196266_4_) {
        return false;
    }

    @Nullable
    public MenuProvider m_7246_(BlockState p_220052_1_, Level p_220052_2_, BlockPos p_220052_3_) {
        return super.m_7246_(p_220052_1_, p_220052_2_, p_220052_3_);
    }
}

