/*
 * Decompiled with CFR 0.152.
 */
package lu.kolja.expandedae.mixin.terminal;

import appeng.api.config.Actionable;
import appeng.api.networking.IGridNode;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.ITerminalHost;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableItem;
import appeng.core.definitions.AEItems;
import appeng.helpers.IMenuCraftingPacket;
import appeng.helpers.IPatternTerminalMenuHost;
import appeng.menu.locator.MenuLocator;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.me.items.PatternEncodingTermMenu;
import appeng.menu.slot.RestrictedInputSlot;
import appeng.util.ConfigInventory;
import de.mari_023.ae2wtlib.wut.WUTHandler;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import lu.kolja.expandedae.definition.ExpItems;
import lu.kolja.expandedae.helper.misc.KeybindUtil;
import lu.kolja.expandedae.helper.patternprovider.IPatternEncodingTerminalMenu;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PatternEncodingTermMenu.class}, remap=false)
public abstract class MixinPatternEncodingTerminalMenu
extends MEStorageMenu
implements IMenuCraftingPacket,
IPatternEncodingTerminalMenu {
    @Final
    @Shadow
    @Mutable
    private RestrictedInputSlot encodedPatternSlot;
    @Shadow
    @Final
    private RestrictedInputSlot blankPatternSlot;
    @Shadow(remap=false)
    @Final
    private ConfigInventory encodedInputsInv;
    @Shadow(remap=false)
    @Final
    private ConfigInventory encodedOutputsInv;

    protected MixinPatternEncodingTerminalMenu(MenuType<?> menuType, int id, Inventory ip, ITerminalHost host) {
        super(menuType, id, ip, host);
    }

    @Inject(method={"encode"}, at={@At(value="RETURN")})
    private void encode(CallbackInfo ci) {
        IGridNode node = this.getNetworkNode();
        AtomicReference player = new AtomicReference();
        this.getActionSource().player().ifPresent(player::set);
        if (this.encodedPatternSlot.m_7993_() != ItemStack.f_41583_) {
            IUpgradeableItem item;
            IUpgradeInventory inventory;
            ItemStack terminalItem;
            if (KeybindUtil.isShiftDown() && ((Player)player.get()).m_150109_().m_36062_() > 0) {
                ((Player)player.get()).m_36356_(this.encodedPatternSlot.m_7993_());
                this.encodedPatternSlot.m_5852_(ItemStack.f_41583_);
                this.encodedPatternSlot.m_6654_();
            }
            if ((terminalItem = this.expandedae$getTerminalItem((Player)player.get())) == null) {
                return;
            }
            Item item2 = terminalItem.m_41720_();
            if (item2 instanceof IUpgradeableItem && !(inventory = (item = (IUpgradeableItem)item2).getUpgrades(((Player)player.get()).m_21205_())).isInstalled(ExpItems.PATTERN_REFILLER_CARD)) {
                return;
            }
            int blankPatternSlotCount = this.blankPatternSlot.m_7993_().m_41613_();
            if (node == null) {
                return;
            }
            int changed = (int)Objects.requireNonNull(node).getGrid().getStorageService().getInventory().extract((AEKey)AEItemKey.of((ItemLike)AEItems.BLANK_PATTERN), (long)(64 - blankPatternSlotCount), Actionable.MODULATE, this.getActionSource());
            this.blankPatternSlot.m_5852_(new ItemStack((ItemLike)AEItems.BLANK_PATTERN, blankPatternSlotCount + changed));
            this.blankPatternSlot.m_6654_();
        }
    }

    @Unique
    @Nullable
    private ItemStack expandedae$getTerminalItem(Player player) {
        MenuLocator locator = WUTHandler.findTerminal((Player)player, (String)"pattern_encoding");
        if (locator == null) {
            return null;
        }
        return WUTHandler.getItemStackFromLocator((Player)player, (MenuLocator)locator);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/inventory/MenuType;ILnet/minecraft/world/entity/player/Inventory;Lappeng/helpers/IPatternTerminalMenuHost;Z)V"}, at={@At(value="TAIL")}, remap=false)
    private void initHooks(MenuType<?> menuType, int id, Inventory ip, IPatternTerminalMenuHost host, boolean bindInventory, CallbackInfo ci) {
        this.registerClientAction("modifyPattern", Integer.class, this::eae$ModifyPattern);
    }

    @Override
    @Unique
    public void eae$ModifyPattern(Integer data) {
        if (this.isClientSide()) {
            this.sendClientAction("modifyPattern", data);
        } else {
            int slot;
            GenericStack[] output = MixinPatternEncodingTerminalMenu.eae$isValid(this.encodedOutputsInv, data);
            if (output == null) {
                return;
            }
            GenericStack[] input = MixinPatternEncodingTerminalMenu.eae$isValid(this.encodedInputsInv, data);
            if (input == null) {
                return;
            }
            for (slot = 0; slot < output.length; ++slot) {
                if (output[slot] == null) continue;
                this.encodedOutputsInv.setStack(slot, output[slot]);
            }
            for (slot = 0; slot < input.length; ++slot) {
                if (input[slot] == null) continue;
                this.encodedInputsInv.setStack(slot, input[slot]);
            }
        }
    }

    @Unique
    private static GenericStack[] eae$isValid(ConfigInventory inv, int data) {
        boolean flag;
        boolean bl = flag = data > 0;
        if (!flag) {
            data = -data;
        }
        GenericStack[] result = new GenericStack[inv.size()];
        for (int slot = 0; slot < inv.size(); ++slot) {
            GenericStack stack = inv.getStack(slot);
            if (stack == null) continue;
            if (flag) {
                if ((long)data * stack.amount() > Integer.MAX_VALUE) {
                    return null;
                }
                result[slot] = new GenericStack(stack.what(), (long)data * stack.amount());
                continue;
            }
            if (stack.amount() % (long)data != 0L) {
                return null;
            }
            result[slot] = new GenericStack(stack.what(), stack.amount() / (long)data);
        }
        return result;
    }
}

