/*
 * Decompiled with CFR 0.152.
 */
package lu.kolja.expandedae.mixin.patternprovider;

import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.IGrid;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.helpers.patternprovider.PatternProviderLogic;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import appeng.helpers.patternprovider.PatternProviderTarget;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.util.ConfigManager;
import com.google.common.collect.ImmutableSet;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lu.kolja.expandedae.definition.ExpItems;
import lu.kolja.expandedae.definition.ExpSettings;
import lu.kolja.expandedae.enums.Addons;
import lu.kolja.expandedae.enums.BlockingMode;
import lu.kolja.expandedae.helper.patternprovider.IPatternProviderLogic;
import lu.kolja.expandedae.helper.patternprovider.PatternProviderTargetCache;
import lu.kolja.expandedae.mixin.accessor.AccessorCraftingCpuLogic;
import lu.kolja.expandedae.mixin.accessor.AccessorExecutingCraftingJob;
import lu.kolja.expandedae.xmod.advancedae.AdvancedAE;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PatternProviderLogic.class}, remap=false, priority=1001)
public abstract class MixinPatternProviderLogic
implements IUpgradeableObject,
IPatternProviderLogic {
    @Unique
    private static final boolean AAE_LOADED = Addons.ADV.isLoaded;
    @Unique
    private PatternProviderTargetCache[] expandedae$targetCaches;
    @Shadow
    @Final
    private IActionSource actionSource;
    @Unique
    private IUpgradeInventory eae_$upgrades = UpgradeInventories.empty();
    @Final
    @Shadow
    private PatternProviderLogicHost host;
    @Final
    @Shadow
    private IManagedGridNode mainNode;
    @Shadow
    @Final
    private ConfigManager configManager;

    @Shadow
    @Nullable
    public abstract IGrid getGrid();

    @Unique
    private void eae_$onUpgradesChanged() {
        this.host.saveChanges();
    }

    public IUpgradeInventory getUpgrades() {
        return this.eae_$upgrades;
    }

    @Inject(method={"<init>(Lappeng/api/networking/IManagedGridNode;Lappeng/helpers/patternprovider/PatternProviderLogicHost;I)V"}, at={@At(value="TAIL")})
    private void eae_$initUpgrade(IManagedGridNode mainNode, PatternProviderLogicHost host, int patternInventorySize, CallbackInfo ci) {
        this.eae_$upgrades = UpgradeInventories.forMachine((ItemLike)host.getTerminalIcon().getItem(), (int)1, this::eae_$onUpgradesChanged);
        this.expandedae$targetCaches = new PatternProviderTargetCache[6];
    }

    @Inject(method={"writeToNBT"}, at={@At(value="TAIL")})
    private void eae_$saveUpgrade(CompoundTag tag, CallbackInfo ci) {
        this.eae_$upgrades.writeToNBT(tag, "upgrades");
    }

    @Inject(method={"readFromNBT"}, at={@At(value="TAIL")})
    private void eae_$loadUpgrade(CompoundTag tag, CallbackInfo ci) {
        this.eae_$upgrades.readFromNBT(tag, "upgrades");
    }

    @Inject(method={"addDrops"}, at={@At(value="TAIL")})
    private void eae_$dropUpgrade(List<ItemStack> drops, CallbackInfo ci) {
        for (ItemStack is : this.eae_$upgrades) {
            if (is.m_41619_()) continue;
            drops.add(is);
        }
    }

    @Inject(method={"clearContent"}, at={@At(value="TAIL")})
    private void eae_$clearUpgrade(CallbackInfo ci) {
        this.eae_$upgrades.clear();
    }

    @Inject(method={"<init>(Lappeng/api/networking/IManagedGridNode;Lappeng/helpers/patternprovider/PatternProviderLogicHost;I)V"}, at={@At(value="TAIL")}, remap=false)
    private void PatternProviderLogic(IManagedGridNode mainNode, PatternProviderLogicHost host, int patternInventorySize, CallbackInfo ci) {
        this.configManager.registerSetting(ExpSettings.BLOCKING_MODE, (Enum)BlockingMode.DEFAULT);
    }

    @Override
    public BlockingMode expandedae$getBlockingMode() {
        return (BlockingMode)this.configManager.getSetting(ExpSettings.BLOCKING_MODE);
    }

    @Overwrite
    @Nullable
    private PatternProviderTarget findAdapter(Direction side) {
        if (this.expandedae$targetCaches[side.m_122411_()] == null) {
            BlockEntity thisBe = this.host.getBlockEntity();
            this.expandedae$targetCaches[side.m_122411_()] = new PatternProviderTargetCache((ServerLevel)thisBe.m_58904_(), thisBe.m_58899_().m_121945_(side), side.m_122424_(), this.actionSource, this.configManager);
        }
        return this.expandedae$targetCaches[side.m_122411_()].find();
    }

    @Inject(method={"pushPattern"}, at={@At(value="HEAD")})
    private void expandedae$onPushPatternSuccess(IPatternDetails patternDetails, KeyCounter[] inputHolder, CallbackInfoReturnable<Boolean> cir) {
        this.expandedae$tryAutoCompleteCraft(patternDetails);
    }

    @Unique
    private void expandedae$tryAutoCompleteCraft(IPatternDetails details) {
        if (!this.eae_$upgrades.isInstalled(ExpItems.AUTO_COMPLETE_CARD)) {
            return;
        }
        ImmutableSet cpus = this.getGrid().getCraftingService().getCpus();
        for (ICraftingCPU cpu : cpus) {
            if (!cpu.isBusy()) continue;
            if (cpu instanceof CraftingCPUCluster) {
                CraftingCPUCluster cluster = (CraftingCPUCluster)cpu;
                AccessorExecutingCraftingJob.AccessorTaskProgress task = ((AccessorExecutingCraftingJob)((AccessorCraftingCpuLogic)cluster.craftingLogic).getJob()).getTasks().get(details);
                if (task == null || task.getValue() > 1L) continue;
                cluster.cancelJob();
                return;
            }
            if (!AAE_LOADED) continue;
            AdvancedAE.handleCpu(cpu, details);
        }
    }

    @ModifyArg(method={"pushPattern"}, at=@At(value="INVOKE", target="Lappeng/helpers/patternprovider/PatternProviderTarget;containsPatternInput(Ljava/util/Set;)Z"))
    private Set<AEKey> modifiedContainsPatternInput(Set<AEKey> patternInputs, @Local(argsOnly=true) IPatternDetails patternDetails) {
        if (this.expandedae$getBlockingMode() != BlockingMode.SMART) {
            return patternInputs;
        }
        HashSet<AEKey> result = new HashSet<AEKey>();
        for (IPatternDetails.IInput input : patternDetails.getInputs()) {
            result.add(input.getPossibleInputs()[0].what());
        }
        return result;
    }
}

