/*
 * Decompiled with CFR 0.152.
 */
package lu.kolja.expandedae.mixin.misc;

import appeng.client.gui.MathExpressionParser;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Stack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={MathExpressionParser.class}, remap=false)
public class MixinMathExpressionParser {
    @Overwrite
    public static Optional<BigDecimal> parse(String expression, DecimalFormat decimalFormat) {
        ArrayList<Comparable<BigDecimal>> output = new ArrayList<Comparable<BigDecimal>>();
        Stack<Character> operatorStack = new Stack<Character>();
        boolean wasNumberOrRightBracket = false;
        int i = 0;
        while (i < expression.length()) {
            char currentOperator;
            char c;
            if (Character.isWhitespace(expression.charAt(i))) {
                ++i;
                continue;
            }
            if (!wasNumberOrRightBracket || expression.charAt(i) != '-') {
                int start = i;
                c = '\u0000';
                boolean hasE = false;
                boolean isValidScientific = false;
                while (i + c < expression.length()) {
                    char c2 = expression.charAt(i + c);
                    if (!hasE && (Character.isDigit(c2) || c2 == '.')) {
                        ++c;
                        continue;
                    }
                    if (!hasE && c2 == 'e') {
                        hasE = true;
                        ++c;
                        continue;
                    }
                    if (hasE && c == i - start + 1 && (c2 == '+' || c2 == '-')) {
                        ++c;
                        continue;
                    }
                    if (!hasE || !Character.isDigit(c2)) break;
                    ++c;
                    isValidScientific = true;
                }
                if (hasE && isValidScientific) {
                    try {
                        String numStr = expression.substring(start, start + c);
                        BigDecimal decimal = new BigDecimal(numStr);
                        output.add(decimal);
                        i = start + c;
                        wasNumberOrRightBracket = true;
                        continue;
                    }
                    catch (NumberFormatException numStr) {
                        // empty catch block
                    }
                }
                ParsePosition position = new ParsePosition(i);
                Number parsedNumber = decimalFormat.parse(expression, position);
                if (position.getErrorIndex() == -1) {
                    if (!(parsedNumber instanceof BigDecimal)) {
                        return Optional.empty();
                    }
                    BigDecimal decimal = (BigDecimal)parsedNumber;
                    output.add(decimal);
                    i = position.getIndex();
                    wasNumberOrRightBracket = true;
                    continue;
                }
            }
            if ((currentOperator = expression.charAt(i)) == '!' && wasNumberOrRightBracket) {
                output.add(Character.valueOf('!'));
                ++i;
                continue;
            }
            if (currentOperator == '-' && !wasNumberOrRightBracket) {
                currentOperator = 'u';
            }
            wasNumberOrRightBracket = false;
            switch (currentOperator) {
                case '(': 
                case 'u': {
                    operatorStack.push(Character.valueOf(currentOperator));
                    break;
                }
                case ')': {
                    while (true) {
                        if (operatorStack.isEmpty()) {
                            return Optional.empty();
                        }
                        c = ((Character)operatorStack.pop()).charValue();
                        if (c == '(') break;
                        output.add(Character.valueOf(c));
                    }
                    wasNumberOrRightBracket = true;
                    break;
                }
                case '*': 
                case '+': 
                case '-': 
                case '/': 
                case '^': {
                    while (!operatorStack.isEmpty() && (c = (char)((Character)operatorStack.peek()).charValue()) != '(' && MixinMathExpressionParser.precedenceCheck(c, currentOperator)) {
                        operatorStack.pop();
                        output.add(Character.valueOf(c));
                    }
                    operatorStack.push(Character.valueOf(currentOperator));
                    break;
                }
                default: {
                    return Optional.empty();
                }
            }
            ++i;
        }
        while (!operatorStack.isEmpty()) {
            output.add((Comparable<BigDecimal>)operatorStack.pop());
        }
        Stack<BigDecimal> number = new Stack<BigDecimal>();
        for (Object e : output) {
            if (e instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)e;
                number.push(bigDecimal);
                continue;
            }
            char currentOperator = ((Character)e).charValue();
            if (currentOperator == '!') {
                if (number.isEmpty()) {
                    return Optional.empty();
                }
                BigDecimal operand = (BigDecimal)number.pop();
                if (operand.compareTo(BigDecimal.ZERO) < 0 || operand.scale() > 0) {
                    return Optional.empty();
                }
                try {
                    int n = operand.intValueExact();
                    if (n > 20) {
                        return Optional.empty();
                    }
                    BigDecimal result = BigDecimal.ONE;
                    for (int i2 = 2; i2 <= n; ++i2) {
                        result = result.multiply(new BigDecimal(i2));
                    }
                    number.push(result);
                    continue;
                }
                catch (ArithmeticException e2) {
                    return Optional.empty();
                }
            }
            if (currentOperator != 'u') {
                if (number.size() < 2) {
                    return Optional.empty();
                }
                BigDecimal right = (BigDecimal)number.pop();
                BigDecimal left = (BigDecimal)number.pop();
                switch (currentOperator) {
                    case '+': {
                        number.push(right.add(left));
                        break;
                    }
                    case '*': {
                        number.push(right.multiply(left));
                        break;
                    }
                    case '-': {
                        number.push(left.subtract(right));
                        break;
                    }
                    case '/': {
                        if (right.compareTo(BigDecimal.ZERO) == 0) {
                            return Optional.empty();
                        }
                        number.push(left.divide(right, 8, RoundingMode.FLOOR));
                        break;
                    }
                    case '^': {
                        if (right.scale() > 0) {
                            return Optional.empty();
                        }
                        try {
                            int exponent = right.intValueExact();
                            if (exponent < 0 && left.compareTo(BigDecimal.ZERO) == 0) {
                                return Optional.empty();
                            }
                            if (exponent < 0) {
                                BigDecimal result = BigDecimal.ONE.divide(left.pow(-exponent), 8, RoundingMode.FLOOR);
                                number.push(result);
                                break;
                            }
                            number.push(left.pow(exponent));
                            break;
                        }
                        catch (ArithmeticException e3) {
                            return Optional.empty();
                        }
                    }
                    case '(': 
                    case ')': {
                        return Optional.empty();
                    }
                    default: {
                        throw new IllegalStateException("Unreachable character : " + currentOperator);
                    }
                }
                continue;
            }
            if (number.isEmpty()) {
                return Optional.empty();
            }
            number.push(((BigDecimal)number.pop()).negate());
        }
        if (number.size() != 1) {
            return Optional.empty();
        }
        return Optional.of(((BigDecimal)number.pop()).stripTrailingZeros());
    }

    @Overwrite
    private static int getPrecedence(char operator) {
        return switch (operator) {
            case '!' -> -1;
            case 'u' -> 0;
            case '^' -> 1;
            case '*', '/' -> 2;
            case '+', '-' -> 3;
            default -> throw new IllegalArgumentException("Invalid Operator : " + operator);
        };
    }

    @Overwrite
    private static boolean precedenceCheck(char first, char second) {
        if (first == '^' && second == '^') {
            return false;
        }
        return MixinMathExpressionParser.getPrecedence(first) < MixinMathExpressionParser.getPrecedence(second);
    }
}

