/*
 * Decompiled with CFR 0.152.
 */
package lu.kolja.expandedae.helper.patternprovider;

import appeng.api.behaviors.ExternalStorageStrategy;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.storage.MEStorage;
import appeng.capabilities.Capabilities;
import appeng.helpers.patternprovider.PatternProviderTarget;
import appeng.me.storage.CompositeStorage;
import appeng.parts.automation.StackWorldBehaviors;
import appeng.util.BlockApiCache;
import appeng.util.ConfigManager;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import lu.kolja.expandedae.definition.ExpSettings;
import lu.kolja.expandedae.enums.BlockingMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.Nullable;

public class PatternProviderTargetCache {
    private final ResourceLocation programmedCircuit = ResourceLocation.fromNamespaceAndPath((String)"gtceu", (String)"programmed_circuit");
    private final BlockApiCache<MEStorage> cache;
    private final Direction direction;
    private final IActionSource src;
    private final Map<AEKeyType, ExternalStorageStrategy> strategies;
    private final ConfigManager configManager;

    public PatternProviderTargetCache(ServerLevel l, BlockPos pos, Direction direction, IActionSource src, ConfigManager configManager) {
        this.cache = BlockApiCache.create((Capability)Capabilities.STORAGE, (ServerLevel)l, (BlockPos)pos);
        this.direction = direction;
        this.src = src;
        this.strategies = StackWorldBehaviors.createExternalStorageStrategies((ServerLevel)l, (BlockPos)pos, (Direction)direction);
        this.configManager = configManager;
    }

    @Nullable
    public PatternProviderTarget find() {
        MEStorage meStorage = (MEStorage)this.cache.find(this.direction);
        if (meStorage != null) {
            return this.wrapMeStorage(meStorage);
        }
        IdentityHashMap<AEKeyType, MEStorage> externalStorages = new IdentityHashMap<AEKeyType, MEStorage>(2);
        for (Map.Entry<AEKeyType, ExternalStorageStrategy> entry : this.strategies.entrySet()) {
            MEStorage wrapper = entry.getValue().createWrapper(false, () -> {});
            if (wrapper == null) continue;
            externalStorages.put(entry.getKey(), wrapper);
        }
        if (!externalStorages.isEmpty()) {
            return this.wrapMeStorage((MEStorage)new CompositeStorage(externalStorages));
        }
        return null;
    }

    private PatternProviderTarget wrapMeStorage(final MEStorage storage) {
        return new PatternProviderTarget(){

            public long insert(AEKey what, long amount, Actionable type) {
                return storage.insert(what, amount, type, PatternProviderTargetCache.this.src);
            }

            public boolean containsPatternInput(Set<AEKey> patternInputs) {
                switch ((BlockingMode)PatternProviderTargetCache.this.configManager.getSetting(ExpSettings.BLOCKING_MODE)) {
                    case ALL: {
                        for (Object2LongMap.Entry stack : storage.getAvailableStacks()) {
                            if (((AEKey)stack.getKey()).getId().equals((Object)PatternProviderTargetCache.this.programmedCircuit)) continue;
                            return true;
                        }
                        break;
                    }
                    case DEFAULT: {
                        for (Object2LongMap.Entry stack : storage.getAvailableStacks()) {
                            if (((AEKey)stack.getKey()).getId().equals((Object)PatternProviderTargetCache.this.programmedCircuit) || !patternInputs.contains(((AEKey)stack.getKey()).dropSecondary())) continue;
                            return true;
                        }
                        break;
                    }
                    case SMART: {
                        for (Object2LongMap.Entry stack : storage.getAvailableStacks()) {
                            if (((AEKey)stack.getKey()).getId().equals((Object)PatternProviderTargetCache.this.programmedCircuit) || patternInputs.contains(((AEKey)stack.getKey()).dropSecondary())) continue;
                            return true;
                        }
                        break;
                    }
                }
                return false;
            }
        };
    }
}

