/*
 * Decompiled with CFR 0.152.
 */
package lu.kolja.expandedae.helper.misc;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.stacks.GenericStack;
import appeng.crafting.pattern.AEProcessingPattern;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PatternHelper {
    public static final int BASE_FACTOR = 2;

    public static ItemStack modifyPatterns(ItemStack stack, Pair<Boolean, Integer> info, Level level) {
        IPatternDetails detail = PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)level);
        if (detail instanceof AEProcessingPattern) {
            AEProcessingPattern processingPattern = (AEProcessingPattern)detail;
            GenericStack[] input = (GenericStack[])Arrays.stream(processingPattern.getSparseInputs()).toArray(GenericStack[]::new);
            GenericStack[] output = (GenericStack[])Arrays.stream(processingPattern.getOutputs()).toArray(GenericStack[]::new);
            if (PatternHelper.checkModify(input, PatternHelper.getScale((Integer)info.getSecond()), (Boolean)info.getFirst()) && PatternHelper.checkModify(output, PatternHelper.getScale((Integer)info.getSecond()), (Boolean)info.getFirst())) {
                GenericStack[] mulInput = new GenericStack[input.length];
                GenericStack[] mulOutput = new GenericStack[output.length];
                PatternHelper.modifyStacks(input, mulInput, PatternHelper.getScale((Integer)info.getSecond()), (Boolean)info.getFirst());
                PatternHelper.modifyStacks(output, mulOutput, PatternHelper.getScale((Integer)info.getSecond()), (Boolean)info.getFirst());
                return PatternDetailsHelper.encodeProcessingPattern((GenericStack[])mulInput, (GenericStack[])mulOutput);
            }
            return stack;
        }
        return stack;
    }

    public static int getScale(int multiplier) {
        return 2 * multiplier;
    }

    public static boolean checkModify(GenericStack[] stacks, int scale, boolean division) {
        if (division) {
            for (GenericStack stack : stacks) {
                if (stack == null || stack.amount() % (long)scale == 0L) continue;
                return false;
            }
        } else {
            for (GenericStack stack : stacks) {
                if (stack == null) continue;
                long upper = 999999L * (long)stack.what().getAmountPerUnit();
                if (stack.amount() * (long)scale <= upper) continue;
                return false;
            }
        }
        return true;
    }

    public static void modifyStacks(GenericStack[] stacks, GenericStack[] des, int scale, boolean division) {
        for (int i = 0; i < stacks.length; ++i) {
            if (stacks[i] == null) continue;
            long amt = division ? stacks[i].amount() / (long)scale : stacks[i].amount() * (long)scale;
            des[i] = new GenericStack(stacks[i].what(), amt);
        }
    }
}

