/*
 * Decompiled with CFR 0.152.
 */
package lu.kolja.expandedae.definition;

import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.blockentity.crafting.CraftingBlockEntity;
import appeng.blockentity.networking.EnergyCellBlockEntity;
import appeng.core.definitions.BlockDefinition;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import lu.kolja.expandedae.Expandedae;
import lu.kolja.expandedae.block.entity.ExpIOPortBlockEntity;
import lu.kolja.expandedae.block.entity.ExpPatternProviderBlockEntity;
import lu.kolja.expandedae.definition.ExpBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ExpBlockEntities {
    private static final Map<ResourceLocation, BlockEntityType<?>> BLOCK_ENTITY_TYPES = new HashMap();
    public static final BlockEntityType<ExpPatternProviderBlockEntity> EXP_PATTERN_PROVIDER = ExpBlockEntities.create("exp_pattern_provider", ExpPatternProviderBlockEntity.class, ExpPatternProviderBlockEntity::new, ExpBlocks.EXP_PATTERN_PROVIDER);
    public static final BlockEntityType<ExpIOPortBlockEntity> EXP_IO_PORT = ExpBlockEntities.create("exp_io_port", ExpIOPortBlockEntity.class, ExpIOPortBlockEntity::new, ExpBlocks.EXP_IO_PORT);
    public static final BlockEntityType<EnergyCellBlockEntity> EXP_ENERGY_CELL = ExpBlockEntities.create("exp_energy_cell", EnergyCellBlockEntity.class, EnergyCellBlockEntity::new, ExpBlocks.EXP_ENERGY_CELL);
    public static final BlockEntityType<CraftingBlockEntity> EXP_CPUS = ExpBlockEntities.create("exp_cpus", CraftingBlockEntity.class, CraftingBlockEntity::new, ExpBlocks.EXP_CRAFTING_UNIT, ExpBlocks.CPU_2, ExpBlocks.CPU_4, ExpBlocks.CPU_8, ExpBlocks.CPU_16, ExpBlocks.CPU_32, ExpBlocks.CPU_64, ExpBlocks.CPU_128, ExpBlocks.CPU_256, ExpBlocks.CPU_512, ExpBlocks.CPU_1K, ExpBlocks.CPU_2K, ExpBlocks.CPU_4K, ExpBlocks.CPU_8K, ExpBlocks.CPU_16K, ExpBlocks.CPU_32K, ExpBlocks.CPU_64K, ExpBlocks.CPU_128K, ExpBlocks.CPU_256K, ExpBlocks.CPU_512K, ExpBlocks.CPU_1M);

    public static Map<ResourceLocation, BlockEntityType<?>> getBlockEntityTypes() {
        return Collections.unmodifiableMap(BLOCK_ENTITY_TYPES);
    }

    @SafeVarargs
    public static <T extends AEBaseBlockEntity> BlockEntityType<T> create(String id, Class<T> entityClass, BlockEntityFactory<T> factory, BlockDefinition<? extends AEBaseEntityBlock<?>> ... blockDefinitions) {
        if (blockDefinitions.length == 0) {
            throw new IllegalArgumentException();
        }
        AEBaseEntityBlock[] blocks = (AEBaseEntityBlock[])Arrays.stream(blockDefinitions).map(BlockDefinition::block).toArray(AEBaseEntityBlock[]::new);
        AtomicReference<BlockEntityType> typeHolder = new AtomicReference<BlockEntityType>();
        BlockEntityType type = BlockEntityType.Builder.m_155273_((blockPos, blockState) -> factory.create((BlockEntityType)typeHolder.get(), blockPos, blockState), (Block[])blocks).m_58966_(null);
        typeHolder.set(type);
        BLOCK_ENTITY_TYPES.put(Expandedae.makeId(id), type);
        AEBaseBlockEntity.registerBlockEntityItem((BlockEntityType)type, (Item)blockDefinitions[0].m_5456_());
        AEBaseEntityBlock[] aEBaseEntityBlockArray = blocks;
        int n = aEBaseEntityBlockArray.length;
        for (int i = 0; i < n; ++i) {
            AEBaseEntityBlock block;
            AEBaseEntityBlock baseBlock = block = aEBaseEntityBlockArray[i];
            baseBlock.setBlockEntity(entityClass, type, null, null);
        }
        return type;
    }

    public static interface BlockEntityFactory<T extends AEBaseBlockEntity> {
        public T create(BlockEntityType<T> var1, BlockPos var2, BlockState var3);
    }
}

