/*
 * Decompiled with CFR 0.152.
 */
package lu.kolja.expandedae.datagen;

import appeng.block.crafting.AbstractCraftingUnitBlock;
import appeng.block.networking.EnergyCellBlock;
import appeng.core.definitions.BlockDefinition;
import appeng.datagen.providers.models.AE2BlockStateProvider;
import appeng.init.client.InitItemModelsProperties;
import java.util.ArrayList;
import lu.kolja.expandedae.Expandedae;
import lu.kolja.expandedae.definition.ExpBlocks;
import lu.kolja.expandedae.definition.ExpItems;
import lu.kolja.expandedae.enums.ExpTiers;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class ExpModelProvider
extends AE2BlockStateProvider {
    public ExpModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "expandedae", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.basicItem((ItemLike)ExpItems.EXP_PATTERN_PROVIDER_UPGRADE);
        this.basicItem((ItemLike)ExpItems.AUTO_COMPLETE_CARD);
        this.basicItem((ItemLike)ExpItems.PATTERN_REFILLER_CARD);
        this.basicItem((ItemLike)ExpItems.GREATER_ACCEL_CARD);
        this.energyCell(ExpBlocks.EXP_ENERGY_CELL, "block/exp_energy_cell");
        for (ExpTiers cpu : ExpTiers.values()) {
            Block block = cpu.getDefinition().block();
            String name = cpu.isCPU() ? cpu.getCpuAffix() : cpu.getAffix();
            BlockModelBuilder model = (BlockModelBuilder)this.models().cubeAll("block/crafting/" + name, Expandedae.makeId("block/crafting/" + name));
            this.getVariantBuilder(block).partialState().with((Property)AbstractCraftingUnitBlock.FORMED, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)}).partialState().with((Property)AbstractCraftingUnitBlock.FORMED, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getBuilder("block/crafting/" + name + "_formed"))});
            this.simpleBlockItem(block, (ModelFile)model);
        }
    }

    private void basicItem(ItemLike item) {
        this.itemModels().basicItem(item.m_5456_());
    }

    @NotNull
    public String m_6055_() {
        return "Block States / Models";
    }

    private void energyCell(BlockDefinition<?> block, String baseTexture) {
        VariantBlockStateBuilder blockBuilder = this.getVariantBuilder(block.block());
        ArrayList<BlockModelBuilder> models = new ArrayList<BlockModelBuilder>();
        for (int i = 0; i < 5; ++i) {
            BlockModelBuilder model = (BlockModelBuilder)this.models().cubeAll(this.modelPath(block) + "_" + i, Expandedae.makeId(baseTexture + "_" + i));
            blockBuilder.partialState().with((Property)EnergyCellBlock.ENERGY_STORAGE, (Comparable)Integer.valueOf(i)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
            models.add(model);
        }
        ItemModelBuilder item = (ItemModelBuilder)this.itemModels().withExistingParent(this.modelPath(block), ((ModelFile)models.get(0)).getLocation());
        for (int i = 1; i < models.size(); ++i) {
            float fillFactor = (float)i / (float)models.size();
            item.override().predicate(InitItemModelsProperties.ENERGY_FILL_LEVEL_ID, fillFactor).model((ModelFile)models.get(i));
        }
    }

    private String modelPath(BlockDefinition<?> block) {
        return block.id().m_135815_();
    }
}

