/*
 * Decompiled with CFR 0.152.
 */
package lu.kolja.expandedae.client.gui.widgets;

import appeng.client.gui.Icon;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.widgets.ITooltip;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import lu.kolja.expandedae.client.gui.widgets.ExpIcon;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExpIconButton
extends Button
implements ITooltip {
    private boolean halfSize = false;
    private boolean disableClickSound = false;
    private boolean disableBackground = false;

    public ExpIconButton(Button.OnPress onPress) {
        super(0, 0, 16, 16, (Component)Component.m_237119_(), onPress, Button.f_252438_);
    }

    public void setVisibility(boolean vis) {
        this.f_93624_ = vis;
        this.f_93623_ = vis;
    }

    public void m_7435_(@NotNull SoundManager soundHandler) {
        if (!this.disableClickSound) {
            super.m_7435_(soundHandler);
        }
    }

    public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        if (this.f_93624_) {
            ExpIcon icon = this.getIcon();
            Blitter blitter = icon.getBlitter();
            if (!this.f_93623_) {
                blitter.opacity(0.5f);
            }
            if (this.halfSize) {
                this.f_93618_ = 8;
                this.f_93619_ = 8;
            }
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            if (this.m_93696_()) {
                guiGraphics.m_280509_(this.m_252754_() - 1, this.m_252907_() - 1, this.m_252754_() + this.f_93618_ + 1, this.m_252907_(), -1);
                guiGraphics.m_280509_(this.m_252754_() - 1, this.m_252907_(), this.m_252754_(), this.m_252907_() + this.f_93619_, -1);
                guiGraphics.m_280509_(this.m_252754_() + this.f_93618_, this.m_252907_(), this.m_252754_() + this.f_93618_ + 1, this.m_252907_() + this.f_93619_, -1);
                guiGraphics.m_280509_(this.m_252754_() - 1, this.m_252907_() + this.f_93619_, this.m_252754_() + this.f_93618_ + 1, this.m_252907_() + this.f_93619_ + 1, -1);
            }
            if (this.halfSize) {
                PoseStack pose = guiGraphics.m_280168_();
                pose.m_85836_();
                pose.m_252880_((float)this.m_252754_(), (float)this.m_252907_(), 0.0f);
                pose.m_85841_(0.5f, 0.5f, 1.0f);
                if (!this.disableBackground) {
                    Icon.TOOLBAR_BUTTON_BACKGROUND.getBlitter().dest(0, 0).blit(guiGraphics);
                }
                blitter.dest(0, 0).blit(guiGraphics);
                pose.m_85849_();
            } else {
                if (!this.disableBackground) {
                    Icon.TOOLBAR_BUTTON_BACKGROUND.getBlitter().dest(this.m_252754_(), this.m_252907_()).blit(guiGraphics);
                }
                icon.getBlitter().dest(this.m_252754_(), this.m_252907_()).blit(guiGraphics);
            }
            RenderSystem.enableDepthTest();
            Item item = this.getItemOverlay();
            if (item != null) {
                guiGraphics.m_280480_(new ItemStack((ItemLike)item), this.m_252754_(), this.m_252907_());
            }
        }
    }

    protected abstract ExpIcon getIcon();

    @Nullable
    protected Item getItemOverlay() {
        return null;
    }

    public List<Component> getTooltipMessage() {
        return Collections.singletonList(this.m_6035_());
    }

    public Rect2i getTooltipArea() {
        return new Rect2i(this.m_252754_(), this.m_252907_(), this.halfSize ? 8 : 16, this.halfSize ? 8 : 16);
    }

    public boolean isTooltipAreaVisible() {
        return this.f_93624_;
    }

    public boolean isHalfSize() {
        return this.halfSize;
    }

    public void setHalfSize(boolean halfSize) {
        this.halfSize = halfSize;
    }

    public boolean isDisableClickSound() {
        return this.disableClickSound;
    }

    public void setDisableClickSound(boolean disableClickSound) {
        this.disableClickSound = disableClickSound;
    }

    public boolean isDisableBackground() {
        return this.disableBackground;
    }

    public void setDisableBackground(boolean disableBackground) {
        this.disableBackground = disableBackground;
    }
}

