/*
 * Decompiled with CFR 0.152.
 */
package lu.kolja.expandedae.client.button;

import appeng.client.gui.style.Blitter;
import com.glodblock.github.extendedae.client.button.EPPIcon;
import lu.kolja.expandedae.client.button.ExpButton;
import lu.kolja.expandedae.client.render.ExpHighlightHandler;
import lu.kolja.expandedae.client.util.GuiUtil;
import net.minecraft.client.gui.components.Button;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class HighlightButton
extends ExpButton {
    private float multiplier;
    private Runnable successJob;
    private BlockPos pos;
    private ResourceKey<Level> dim;
    @Nullable
    private Direction face;

    public HighlightButton() {
        super(HighlightButton::highlight);
    }

    public void setMultiplier(float multiplier) {
        this.multiplier = multiplier;
    }

    public void setSuccessJob(Runnable successJob) {
        this.successJob = successJob;
    }

    public void setTarget(BlockPos pos, ResourceKey<Level> dim, @Nullable Direction face) {
        this.pos = pos;
        this.dim = dim;
        this.face = face;
    }

    public void setTarget(BlockPos pos, ResourceKey<Level> world) {
        this.setTarget(pos, world, null);
    }

    private static void highlight(Button btn) {
        GL11.glPushMatrix();
        if (btn instanceof HighlightButton) {
            HighlightButton hb = (HighlightButton)btn;
            if (hb.dim != null && hb.pos != null) {
                if (hb.face == null) {
                    ExpHighlightHandler.highlight(hb.pos, hb.dim, System.currentTimeMillis() + (long)(600.0f * hb.multiplier));
                } else {
                    AABB origin = HighlightButton.getNorthPartModel().m_82338_(hb.pos);
                    Vec3 center = new AABB(hb.pos).m_82399_();
                    switch (hb.face) {
                        case WEST: {
                            origin = GuiUtil.rotor(origin, center, Direction.Axis.Y, 1.5707964f);
                            break;
                        }
                        case SOUTH: {
                            origin = GuiUtil.rotor(origin, center, Direction.Axis.Y, (float)Math.PI);
                            break;
                        }
                        case EAST: {
                            origin = GuiUtil.rotor(origin, center, Direction.Axis.Y, -1.5707964f);
                            break;
                        }
                        case UP: {
                            origin = GuiUtil.rotor(origin, center, Direction.Axis.X, -1.5707964f);
                            break;
                        }
                        case DOWN: {
                            AABB aABB = GuiUtil.rotor(origin, center, Direction.Axis.X, 1.5707964f);
                        }
                    }
                }
                if (hb.successJob != null) {
                    hb.successJob.run();
                }
            }
        }
    }

    private static AABB getNorthPartModel() {
        return new AABB(0.125, 0.125, 0.0, 0.875, 0.875, 0.125);
    }

    @Override
    Blitter getBlitterIcon() {
        return EPPIcon.HIGHLIGHT_BLOCK;
    }
}

