/*
 * Decompiled with CFR 0.152.
 */
package com.cpearl.redimstages;

import com.cpearl.redimstages.DimensionRestriction;
import com.cpearl.redimstages.ReDimensionStages;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import org.jetbrains.annotations.NotNull;

public class Restrictions
extends SimplePreparableReloadListener<Void> {
    private final Map<ResourceLocation, DimensionRestriction> restrictions = new HashMap<ResourceLocation, DimensionRestriction>();

    public Restrictions() {
        MinecraftForge.EVENT_BUS.addListener(this::onEntityTravelToDimension);
        MinecraftForge.EVENT_BUS.addListener(this::addReloadListeners);
    }

    public DimensionRestriction addRestriction(ResourceLocation dimensionId, DimensionRestriction restriction) {
        this.restrictions.put(dimensionId, restriction);
        return restriction;
    }

    private void onEntityTravelToDimension(EntityTravelToDimensionEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ResourceLocation dimensionId = event.getDimension().m_135782_();
            DimensionRestriction restriction = this.restrictions.get(dimensionId);
            if (restriction != null && restriction.isRestricted((Player)player)) {
                event.setCanceled(true);
                ReDimensionStages.LOGGER.debug("Restricted {} from accessing dimension {}. Restriction={}", new Object[]{player.m_5446_().getString(), dimensionId, restriction});
                Component message = restriction.restrictionMessage;
                if (message != null) {
                    player.m_5661_(message, true);
                }
            }
        }
    }

    private void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)this);
    }

    @NotNull
    protected Void prepare(ResourceManager manager, ProfilerFiller profiler) {
        return null;
    }

    protected void apply(Void data, ResourceManager manager, ProfilerFiller profiler) {
        this.restrictions.clear();
    }
}

