/*
 * Decompiled with CFR 0.152.
 */
package com.cpearl.redimstages;

import com.blamejared.crafttweaker.api.action.base.IRuntimeAction;
import com.cpearl.redimstages.DimensionRestriction;
import com.cpearl.redimstages.ReDimensionStages;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Logger;

public class ActionStageDimension
implements IRuntimeAction {
    private final String dimensionId;
    private final String[] stages;
    private final Component restrictionMessage;

    public ActionStageDimension(String dimensionId, @Nullable Component message, String ... stages) {
        this.dimensionId = dimensionId;
        this.stages = stages;
        this.restrictionMessage = message;
    }

    public boolean validate(Logger logger) {
        if (ResourceLocation.m_135820_((String)this.dimensionId) == null) {
            logger.error("[Re-Dimension Stages] Invalid dimension '" + this.dimensionId + "'.");
            return false;
        }
        HashSet<String> validStages = new HashSet<String>();
        for (String stage : this.stages) {
            if (!GameStageHelper.isValidStageName((String)stage)) {
                logger.error("[Re-Dimension Stages] Invalid stage name '" + stage + "' for dimension '" + this.dimensionId + "'. " + this.getDeclaredScriptPosition());
                continue;
            }
            if (!GameStageHelper.getKnownStages().isEmpty() && !GameStageHelper.isStageKnown((String)stage)) {
                logger.warn("[Re-Dimension Stages] Unknown stage '" + stage + "' for dimension '" + this.dimensionId + "' " + this.getDeclaredScriptPosition());
            }
            validStages.add(stage);
        }
        if (validStages.isEmpty()) {
            logger.error("[Re-Dimension Stages] No valid stages specified for dimension '" + this.dimensionId + "'. " + this.getDeclaredScriptPosition());
            return false;
        }
        return true;
    }

    public void apply() {
        DimensionRestriction restriction = ReDimensionStages.RESTRICTIONS.addRestriction(new ResourceLocation(this.dimensionId), new DimensionRestriction());
        for (String stage : this.stages) {
            if (!GameStageHelper.isValidStageName((String)stage)) continue;
            restriction.addStage(stage);
        }
        restriction.restrictionMessage = this.restrictionMessage;
    }

    public String describe() {
        return "[Re-Dimension Stages] Staging dimension '" + this.dimensionId + "' to stage(s) '" + Arrays.toString(this.stages) + "'. " + this.getDeclaredScriptPosition();
    }

    public String systemName() {
        return "Re-DimensionStages";
    }
}

