/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.jetboots.mixin;

import com.black_dog20.jetboots.common.util.ModUtils;
import com.black_dog20.jetboots.common.util.properties.JetBootsProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntity {
    protected PlayerEntityMixin(EntityType<? extends LivingEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    @Shadow
    public void m_36222_(ResourceLocation p_36223_, int p_36224_) {
    }

    @Inject(method={"causeFallDamage(FFLnet/minecraft/world/damagesource/DamageSource;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onLivingFallDamage(float distance, float damageMultiplier, DamageSource damageSource, CallbackInfoReturnable<Boolean> ci) {
        PlayerEntityMixin playerEntityMixin = this;
        if (playerEntityMixin instanceof Player) {
            Player player = (Player)playerEntityMixin;
            ItemStack boots = ModUtils.getJetBoots(player);
            if (!boots.m_41619_() && !JetBootsProperties.hasShockUpgrade(boots)) {
                if (distance >= 2.0f) {
                    this.m_36222_(Stats.f_12998_, (int)Math.round((double)distance * 100.0));
                }
                ci.setReturnValue((Object)super.m_142535_(distance, damageMultiplier, damageSource));
                ci.cancel();
            } else if (!boots.m_41619_() && JetBootsProperties.hasShockUpgrade(boots)) {
                ci.setReturnValue((Object)false);
                ci.cancel();
            }
        }
    }
}

