/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.jetboots.common.util.objects;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.items.ItemStackHandler;

public class EnchantableItemHandler
extends ItemStackHandler {
    private static int SIZE = 3;
    private final ItemStack container;

    public EnchantableItemHandler(ItemStack container) {
        super(SIZE);
        this.container = container;
    }

    protected void onContentsChanged(int slot) {
        this.serializeNBT();
        EnchantmentHelper.m_44865_(this.getEnchantmentMap(), (ItemStack)this.container);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        Item item = stack.m_41720_();
        boolean valid = super.isItemValid(slot, stack);
        if (!valid || item != Items.f_42690_) {
            return false;
        }
        Set newEnchantments = EnchantmentHelper.m_44831_((ItemStack)stack).keySet();
        boolean canBeAppliedToItem = newEnchantments.stream().allMatch(e -> e.f_44672_.m_7454_(this.container.m_41720_()));
        if (!canBeAppliedToItem) {
            return false;
        }
        Set<Enchantment> currentEnchantments = this.getEnchantmentMap().keySet();
        return newEnchantments.stream().allMatch(e -> EnchantmentHelper.m_44859_((Collection)currentEnchantments, (Enchantment)e));
    }

    private Map<Enchantment, Integer> getEnchantmentMap() {
        return this.stacks.stream().filter(s -> s.m_41720_() == Items.f_42690_).map(EnchantmentHelper::m_44831_).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Math::max));
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.load();
        super.setStackInSlot(slot, stack);
        this.save();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.load();
        return super.getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        this.load();
        ItemStack ret = super.insertItem(slot, stack, simulate);
        this.save();
        return ret;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        this.load();
        return super.extractItem(slot, amount, simulate);
    }

    private void load() {
        CompoundTag compoundNBT = this.container.m_41784_();
        if (compoundNBT.m_128441_("jetboots-enchantable-container")) {
            super.deserializeNBT(compoundNBT.m_128469_("jetboots-enchantable-container"));
        }
    }

    private void save() {
        this.serializeNBT();
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        this.container.m_41784_().m_128365_("jetboots-enchantable-container", (Tag)nbt);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        CompoundTag compoundNBT = this.container.m_41784_();
        if (compoundNBT.m_128441_("jetboots-enchantable-container")) {
            super.deserializeNBT(compoundNBT.m_128469_("jetboots-enchantable-container"));
        }
    }
}

