/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.jetboots.common.util;

import com.black_dog20.bml.utils.text.TextComponentBuilder;
import com.black_dog20.bml.utils.translate.ITranslation;
import com.black_dog20.jetboots.common.items.ModItems;
import com.black_dog20.jetboots.common.items.equipment.GuardianHelmetItem;
import com.black_dog20.jetboots.common.items.equipment.JetBootsItem;
import com.black_dog20.jetboots.common.items.equipment.RocketBootsItem;
import com.black_dog20.jetboots.common.util.EnergyUtil;
import com.black_dog20.jetboots.common.util.TranslationHelper;
import com.black_dog20.jetboots.common.util.properties.GuardinanHelmetProperties;
import com.black_dog20.jetboots.common.util.properties.JetBootsProperties;
import com.black_dog20.jetboots.common.util.properties.RocketBootsProperties;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;

public class ModUtils {
    public static boolean isJetbootsFlying(Player player) {
        return ModUtils.hasJetBoots(player) && (player.m_150110_().f_35935_ || player.m_21255_());
    }

    public static boolean hasJetBoots(Player player) {
        return player.m_6844_(EquipmentSlot.FEET).m_41720_() instanceof JetBootsItem;
    }

    public static ItemStack getJetBoots(Player player) {
        if (!ModUtils.hasJetBoots(player)) {
            return ItemStack.f_41583_;
        }
        return player.m_6844_(EquipmentSlot.FEET);
    }

    public static boolean canFlyWithJetboots(Player player) {
        if (player.m_7500_()) {
            return true;
        }
        if (!ModUtils.hasJetBoots(player)) {
            return false;
        }
        ItemStack jetboots = ModUtils.getJetBoots(player);
        if (player.m_20069_() && !JetBootsProperties.hasUnderWaterUpgrade(jetboots)) {
            return false;
        }
        IEnergyStorage energy = (IEnergyStorage)jetboots.getCapability(ForgeCapabilities.ENERGY, null).orElse(null);
        if (energy != null) {
            return energy.getEnergyStored() + EnergyUtil.getEnergyWhileFlying(jetboots) >= 0;
        }
        return false;
    }

    public static boolean canUseElytraFlight(Player player) {
        if (!ModUtils.hasJetBoots(player)) {
            return false;
        }
        ItemStack jetboots = ModUtils.getJetBoots(player);
        return ModUtils.canFlyWithJetboots(player) && ModUtils.useElytraFlight(player, jetboots);
    }

    public static boolean useElytraFlight(Player player, ItemStack jetboots) {
        return ModUtils.startUseElytraFlight(jetboots) && (ModUtils.isTwoBlocksOverGround(player) || player.m_20069_() && JetBootsProperties.hasUnderWaterUpgrade(jetboots));
    }

    private static boolean startUseElytraFlight(ItemStack jetboots) {
        return JetBootsProperties.hasEngineUpgrade(jetboots) && JetBootsProperties.getMode(jetboots);
    }

    private static boolean isTwoBlocksOverGround(Player player) {
        return ModUtils.isBlocksOverGround(player, 1.9, 3);
    }

    public static boolean isBlocksOverGround(Player player, double target, int max) {
        if (player.m_20069_()) {
            return true;
        }
        BlockPos blockPos = new BlockPos((Vec3i)player.m_20183_());
        for (int i = 0; i < max && player.m_9236_().m_46859_(blockPos.m_7495_()); ++i) {
            blockPos = blockPos.m_7495_();
        }
        return blockPos.m_123331_(new Vec3i((int)player.m_20185_(), (int)player.m_20186_(), (int)player.m_20189_())) > target;
    }

    public static boolean isBetweenBlocksOverGround(Player player, double minTarget, double maxTarget) {
        if (player.m_20069_()) {
            return true;
        }
        int max = (int)maxTarget + 1;
        BlockPos blockPos = new BlockPos((Vec3i)player.m_20183_());
        for (int i = 0; i < max && player.m_9236_().m_46859_(blockPos.m_7495_()); ++i) {
            blockPos = blockPos.m_7495_();
        }
        double distance = blockPos.m_123331_(new Vec3i((int)player.m_20185_(), (int)player.m_20186_(), (int)player.m_20189_()));
        return minTarget < distance && distance < maxTarget;
    }

    public static Component getFlightModeText(Player player) {
        ItemStack stack = ModUtils.getJetBoots(player);
        return ModUtils.getFlightModeText(stack, ChatFormatting.WHITE);
    }

    public static Component getFlightModeText(ItemStack stack, ChatFormatting color) {
        if (!stack.m_41619_()) {
            Supplier<Boolean> elytraOn = () -> JetBootsProperties.getMode(stack);
            Component elytra = TranslationHelper.Translations.ELYTRA.get(ChatFormatting.LIGHT_PURPLE);
            Component normal = TranslationHelper.Translations.NORMAL.get(ChatFormatting.GREEN);
            return TextComponentBuilder.of((ITranslation)TranslationHelper.Translations.FLIGHT_MODE).format(color).with(":").format(color).space().with(elytra, normal, elytraOn).build();
        }
        return Component.m_237113_((String)"");
    }

    public static Component getFlightSpeedText(Player player) {
        ItemStack stack = ModUtils.getJetBoots(player);
        return ModUtils.getFlightSpeedText(stack, ChatFormatting.WHITE);
    }

    public static Component getFlightSpeedText(ItemStack stack, ChatFormatting color) {
        if (!stack.m_41619_()) {
            Supplier<Boolean> superSpeedOn = () -> JetBootsProperties.getSpeed(stack);
            Component superSpeed = TranslationHelper.Translations.SUPER.get(ChatFormatting.RED);
            Component normal = TranslationHelper.Translations.NORMAL.get(ChatFormatting.GREEN);
            return TextComponentBuilder.of((ITranslation)TranslationHelper.Translations.SPEED_MODE).format(color).with(":").format(color).space().with(superSpeed, normal, superSpeedOn).build();
        }
        return Component.m_237113_((String)"");
    }

    public static boolean hasGuardianHelmet(Player player) {
        return player.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof GuardianHelmetItem;
    }

    public static ItemStack getGuardianHelmet(Player player) {
        if (!ModUtils.hasGuardianHelmet(player)) {
            return ItemStack.f_41583_;
        }
        return player.m_6844_(EquipmentSlot.HEAD);
    }

    public static Component getHelmetModeText(Player player) {
        ItemStack stack = ModUtils.getGuardianHelmet(player);
        return ModUtils.getHelmetModeText(stack);
    }

    public static Component getHelmetModeText(ItemStack helmet) {
        if (!helmet.m_41619_()) {
            Supplier<Boolean> materializedOn = () -> GuardinanHelmetProperties.getMode(helmet);
            Component materialized = TranslationHelper.Translations.MATERIALIZED.get(ChatFormatting.LIGHT_PURPLE);
            Component dematerialized = TranslationHelper.Translations.DEMATERIALIZED.get(ChatFormatting.BLUE);
            return TextComponentBuilder.of((ITranslation)TranslationHelper.Translations.HELMET_MODE).with(":").space().with(materialized, dematerialized, materializedOn).build();
        }
        return Component.m_237113_((String)"");
    }

    public static Component getHelmetNightVisionText(Player player) {
        ItemStack stack = ModUtils.getGuardianHelmet(player);
        return ModUtils.getHelmetNightVisionText(stack);
    }

    public static Component getHelmetNightVisionText(ItemStack helmet) {
        if (!helmet.m_41619_()) {
            Supplier<Boolean> nightVisionOn = () -> GuardinanHelmetProperties.getNightVision(helmet);
            Component on = TranslationHelper.Translations.ON.get(ChatFormatting.GREEN);
            Component off = TranslationHelper.Translations.OFF.get(ChatFormatting.RED);
            return TextComponentBuilder.of((ITranslation)TranslationHelper.Translations.HELMET_NIGHT_VISION).with(":").space().with(on, off, nightVisionOn).build();
        }
        return Component.m_237113_((String)"");
    }

    public static boolean hasRocketBoots(Player player) {
        return player.m_6844_(EquipmentSlot.FEET).m_41720_() instanceof RocketBootsItem;
    }

    public static ItemStack getRocketBoots(Player player) {
        if (!ModUtils.hasRocketBoots(player)) {
            return ItemStack.f_41583_;
        }
        return player.m_6844_(EquipmentSlot.FEET);
    }

    public static Component getEngineStateText(Player player) {
        ItemStack stack = ModUtils.getRocketBoots(player);
        return ModUtils.getEngineStateText(stack, ChatFormatting.WHITE);
    }

    public static Component getEngineStateText(ItemStack stack, ChatFormatting color) {
        if (!stack.m_41619_()) {
            Supplier<Boolean> isOn = () -> RocketBootsProperties.getEngineState(stack);
            Component on = TranslationHelper.Translations.ON.get(ChatFormatting.GREEN);
            Component off = TranslationHelper.Translations.OFF.get(ChatFormatting.RED);
            return TextComponentBuilder.of((Component)((Item)ModItems.ROCKET_BOOTS.get()).m_7626_(stack)).format(color).with(":").format(color).space().with(on, off, isOn).build();
        }
        return Component.m_237113_((String)"");
    }
}

