/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.jetboots.common.util;

import com.black_dog20.bml.utils.leveling.ItemLevelProperties;
import com.black_dog20.bml.utils.math.MathUtil;
import com.black_dog20.bml.utils.text.TextComponentBuilder;
import com.black_dog20.bml.utils.translate.ITranslation;
import com.black_dog20.jetboots.Config;
import com.black_dog20.jetboots.common.items.equipment.JetBootsItem;
import com.black_dog20.jetboots.common.util.TranslationHelper;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyUtil {
    public static int getEnergyWhileFlying(ItemStack jetboots) {
        if (jetboots.m_41619_() || !(jetboots.m_41720_() instanceof JetBootsItem)) {
            return 0;
        }
        double modifier = ItemLevelProperties.calculateValue((double)1.0, (double)0.5, (ItemStack)jetboots);
        modifier = MathUtil.clamp((double)modifier, (double)0.0, (double)1.0);
        return (int)Math.ceil((double)(-Math.abs((Integer)Config.POWER_COST.get())) * modifier);
    }

    public static void extractOrReceive(IEnergyStorage energyStorage, int value) {
        if (value < 0) {
            energyStorage.extractEnergy(Math.abs(value), false);
        } else {
            energyStorage.receiveEnergy(value, false);
        }
    }

    public static int getBatteryPercentage(ItemStack jetboots) {
        IEnergyStorage energy = (IEnergyStorage)jetboots.getCapability(ForgeCapabilities.ENERGY, null).orElse(null);
        if (energy != null) {
            return Math.min((int)((float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored() * 100.0f), 100);
        }
        return 0;
    }

    public static Optional<Component> getFormattedEnergyCost(ItemStack jetboots) {
        int value = EnergyUtil.getEnergyWhileFlying(jetboots);
        if (value == 0) {
            return Optional.empty();
        }
        MutableComponent textComponent = TextComponentBuilder.of((ITranslation)TranslationHelper.Translations.FLYING_ENERGY).format(ChatFormatting.GRAY).with(":").format(ChatFormatting.GRAY).space().with(String.format("-%d FE", Math.abs(value))).format(ChatFormatting.RED).build();
        return Optional.of(textComponent);
    }
}

