/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.jetboots.common.recipe;

import com.black_dog20.jetboots.common.items.ModItems;
import com.black_dog20.jetboots.common.items.UpgradeItem;
import com.black_dog20.jetboots.common.items.equipment.GuardianHelmetItem;
import com.black_dog20.jetboots.common.items.equipment.GuardianJacketItem;
import com.black_dog20.jetboots.common.items.equipment.GuardianPantsItem;
import com.black_dog20.jetboots.common.items.equipment.GuardianSwordItem;
import com.black_dog20.jetboots.common.items.equipment.JetBootsItem;
import com.black_dog20.jetboots.common.items.equipment.RocketBootsItem;
import com.black_dog20.jetboots.common.recipe.ModRecipeSerializers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.level.Level;

public class CustomSmithingRecipe
extends SmithingTransformRecipe {
    private static final Map<UpgradeItem.Type, Predicate<ItemStack>> MATCHER = Map.of(UpgradeItem.Type.HELMET, CustomSmithingRecipe.createTypeMatcher(GuardianHelmetItem.class), UpgradeItem.Type.JACKET, CustomSmithingRecipe.createTypeMatcher(GuardianJacketItem.class), UpgradeItem.Type.PANTS, CustomSmithingRecipe.createTypeMatcher(GuardianPantsItem.class), UpgradeItem.Type.BOOTS, CustomSmithingRecipe.createTypeMatcher(JetBootsItem.class), UpgradeItem.Type.ROCKET_BOOTS, CustomSmithingRecipe.createTypeMatcher(RocketBootsItem.class), UpgradeItem.Type.SWORD, CustomSmithingRecipe.createTypeMatcher(GuardianSwordItem.class));
    final Ingredient template;
    final Ingredient base;
    final Ingredient addition;
    final ItemStack result;

    public CustomSmithingRecipe(ResourceLocation pId, Ingredient pTemplate, Ingredient pBase, Ingredient pAddition, ItemStack pResult) {
        super(pId, pTemplate, pBase, pAddition, pResult);
        this.template = pTemplate;
        this.base = pBase;
        this.addition = pAddition;
        this.result = pResult;
    }

    public boolean m_5818_(Container inv, Level world) {
        ItemStack template = inv.m_8020_(0);
        ItemStack input = inv.m_8020_(1);
        ItemStack addition = inv.m_8020_(2);
        if (!template.m_150930_((Item)ModItems.JET_BOOTS_TEMPLATE.get())) {
            return false;
        }
        Item item = addition.m_41720_();
        if (item instanceof UpgradeItem) {
            UpgradeItem upgradeItem = (UpgradeItem)item;
            if (addition.m_41613_() == 1) {
                if (upgradeItem.hasBeenAppliedAlready(input).booleanValue()) {
                    return false;
                }
                for (UpgradeItem.Type type : upgradeItem.getTypes()) {
                    if (!MATCHER.getOrDefault((Object)type, i -> false).test(input)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
        ItemStack stack = pContainer.m_8020_(1).m_41777_();
        UpgradeItem addition = (UpgradeItem)pContainer.m_8020_(2).m_41720_();
        return addition.applyUpgrade(stack);
    }

    public boolean m_266253_(ItemStack addition) {
        return addition.m_41720_() instanceof UpgradeItem;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.CUSTOM_SMITHING.get();
    }

    private static Predicate<ItemStack> createTypeMatcher(Class<?> clazz) {
        return stack -> clazz.isInstance(stack.m_41720_()) && stack.m_41613_() == 1;
    }

    public static class Serializer
    implements RecipeSerializer<CustomSmithingRecipe> {
        public CustomSmithingRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)pJson, (String)"template"));
            Ingredient ingredient1 = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)pJson, (String)"base"));
            Ingredient ingredient2 = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)pJson, (String)"addition"));
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pJson, (String)"result"));
            return new CustomSmithingRecipe(pRecipeId, ingredient, ingredient1, ingredient2, itemstack);
        }

        public CustomSmithingRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            Ingredient ingredient1 = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            Ingredient ingredient2 = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            ItemStack itemstack = pBuffer.m_130267_();
            return new CustomSmithingRecipe(pRecipeId, ingredient, ingredient1, ingredient2, itemstack);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, CustomSmithingRecipe pRecipe) {
            pRecipe.template.m_43923_(pBuffer);
            pRecipe.base.m_43923_(pBuffer);
            pRecipe.addition.m_43923_(pBuffer);
            pBuffer.m_130055_(pRecipe.result);
        }
    }
}

