/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.jetboots.common.network.packets;

import com.black_dog20.jetboots.common.network.PacketHandler;
import com.black_dog20.jetboots.common.network.packets.PacketSyncPartical;
import com.black_dog20.jetboots.common.network.packets.PacketSyncSound;
import com.black_dog20.jetboots.common.network.packets.PacketSyncStopSound;
import com.black_dog20.jetboots.common.util.ModUtils;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class PacketSyncRocketFlight {
    private final boolean isFlying;

    public PacketSyncRocketFlight(boolean isFlying) {
        this.isFlying = isFlying;
    }

    public static void encode(PacketSyncRocketFlight msg, FriendlyByteBuf buffer) {
        buffer.writeBoolean(msg.isFlying);
    }

    public static PacketSyncRocketFlight decode(FriendlyByteBuf buffer) {
        return new PacketSyncRocketFlight(buffer.readBoolean());
    }

    public static class Handler {
        public static void handle(PacketSyncRocketFlight msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null) {
                    return;
                }
                if (!ModUtils.hasRocketBoots((Player)player)) {
                    PacketHandler.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new PacketSyncStopSound(player.m_20148_()));
                    return;
                }
                if (msg.isFlying) {
                    player.f_19789_ = 0.0f;
                    if (player.f_8906_ != null) {
                        player.f_8906_.f_9737_ = 0;
                    }
                    PacketHandler.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new PacketSyncPartical(player.m_20148_(), true));
                    if (!player.m_20069_()) {
                        PacketHandler.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new PacketSyncSound(player.m_20148_()));
                    } else {
                        PacketHandler.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new PacketSyncStopSound(player.m_20148_()));
                    }
                } else {
                    PacketHandler.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new PacketSyncStopSound(player.m_20148_()));
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

