/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.jetboots.common.network.packets;

import com.black_dog20.jetboots.client.ClientHelper;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PacketSyncPartical {
    private final UUID uuid;
    private final boolean flying;

    public PacketSyncPartical(UUID uuid, boolean flying) {
        this.uuid = uuid;
        this.flying = flying;
    }

    public static void encode(PacketSyncPartical msg, FriendlyByteBuf buffer) {
        buffer.m_130070_(msg.uuid.toString());
        buffer.writeBoolean(msg.flying);
    }

    public static PacketSyncPartical decode(FriendlyByteBuf buffer) {
        return new PacketSyncPartical(UUID.fromString(buffer.m_130277_()), buffer.readBoolean());
    }

    public static class Handler {
        public static void handle(PacketSyncPartical msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
                Player player = Minecraft.m_91087_().f_91073_.m_46003_(msg.uuid);
                ClientHelper.spawnJetParticals(Minecraft.m_91087_(), player, msg.flying);
            }));
            ctx.get().setPacketHandled(true);
        }
    }
}

