/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.jetboots.common.network.packets;

import com.black_dog20.bml.utils.leveling.ItemLevelProperties;
import com.black_dog20.jetboots.common.items.equipment.RocketBootsItem;
import com.black_dog20.jetboots.common.util.ModUtils;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketAwardRocketBootXp {
    private final int xp;

    public PacketAwardRocketBootXp(int xp) {
        this.xp = xp;
    }

    public static void encode(PacketAwardRocketBootXp msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.xp);
    }

    public static PacketAwardRocketBootXp decode(FriendlyByteBuf buffer) {
        return new PacketAwardRocketBootXp(buffer.readInt());
    }

    public static class Handler {
        public static void handle(PacketAwardRocketBootXp msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null) {
                    return;
                }
                if (!ModUtils.hasRocketBoots((Player)player)) {
                    return;
                }
                ItemStack stack = ModUtils.getRocketBoots((Player)player);
                if (!stack.m_41619_() && stack.m_41720_() instanceof RocketBootsItem) {
                    ItemLevelProperties.addXp((Player)player, (ItemStack)stack, (int)msg.xp);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

