/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.jetboots.common.items.equipment;

import com.black_dog20.bml.utils.keybinds.KeybindsUtil;
import com.black_dog20.bml.utils.leveling.ItemLevelProperties;
import com.black_dog20.bml.utils.math.MathUtil;
import com.black_dog20.jetboots.Config;
import com.black_dog20.jetboots.api.events.ExtraTooltipEvent;
import com.black_dog20.jetboots.client.keybinds.Keybinds;
import com.black_dog20.jetboots.common.capabilities.JetbootsCapabilities;
import com.black_dog20.jetboots.common.items.BaseGuardianArmorItem;
import com.black_dog20.jetboots.common.items.materials.GuardianMaterial;
import com.black_dog20.jetboots.common.util.EnergyUtil;
import com.black_dog20.jetboots.common.util.ModUtils;
import com.black_dog20.jetboots.common.util.TranslationHelper;
import com.black_dog20.jetboots.common.util.properties.JetBootsProperties;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.eventbus.api.Event;

public class JetBootsItem
extends BaseGuardianArmorItem {
    public JetBootsItem(Item.Properties builder) {
        super(GuardianMaterial.getInstance(), ArmorItem.Type.BOOTS, builder.m_41503_(-1).setNoRepair());
    }

    @Override
    protected double getCustomDamageReduceAmount(ItemStack stack) {
        return ItemLevelProperties.calculateValue((double)((Double)Config.JETBOOTS_BASE_DAMAGE_REDUCE_AMOUNT.get()), (double)((Double)Config.JETBOOTS_MAX_DAMAGE_REDUCE_AMOUNT.get()), (ItemStack)stack);
    }

    @Override
    protected double getCustomToughness(ItemStack stack) {
        return ItemLevelProperties.calculateValue((double)((Double)Config.JETBOOTS_BASE_TOUGHNESS_AMOUNT.get()), (double)((Double)Config.JETBOOTS_MAX_TOUGHNESS_AMOUNT.get()), (ItemStack)stack);
    }

    @Override
    protected double getCustomKnockbackResistance(ItemStack stack) {
        return ItemLevelProperties.calculateValue((double)((Double)Config.JETBOOTS_BASE_KNOCKBACK_RESISTANCE_AMOUNT.get()), (double)((Double)Config.JETBOOTS_MAX_KNOCKBACK_RESISTANCE_AMOUNT.get()), (ItemStack)stack);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "jetboots:textures/armor/jetboots.png";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        ExtraTooltipEvent normalExtraTooltips;
        super.m_7373_(stack, world, tooltip, flag);
        KeyMapping sneak = Minecraft.m_91087_().f_91066_.f_92090_;
        stack.getCapability(ForgeCapabilities.ENERGY, null).ifPresent(energy -> tooltip.add(TranslationHelper.Translations.STORED_ENERGY.get(ChatFormatting.GREEN, new Object[]{MathUtil.formatThousands((int)energy.getEnergyStored()), MathUtil.formatThousands((int)energy.getMaxEnergyStored())})));
        EnergyUtil.getFormattedEnergyCost(stack).ifPresent(tooltip::add);
        if (JetBootsProperties.hasEngineUpgrade(stack) || JetBootsProperties.hasThrusterUpgrade(stack)) {
            if (JetBootsProperties.hasEngineUpgrade(stack)) {
                tooltip.add(TranslationHelper.Translations.CHANGE_FLIGHT_MODE.get(ChatFormatting.GRAY, new Object[]{KeybindsUtil.getKeyBindText((KeyMapping)Keybinds.keyMode)}));
            }
            if (JetBootsProperties.hasThrusterUpgrade(stack)) {
                tooltip.add(TranslationHelper.Translations.CHANGE_SPEED_MODE.get(ChatFormatting.GRAY, new Object[]{KeybindsUtil.getKeyBindText((KeyMapping)Keybinds.keySpeed)}));
            }
            if (JetBootsProperties.hasEngineUpgrade(stack)) {
                tooltip.add(ModUtils.getFlightModeText(stack, ChatFormatting.GRAY));
            }
            if (JetBootsProperties.hasThrusterUpgrade(stack)) {
                tooltip.add(ModUtils.getFlightSpeedText(stack, ChatFormatting.GRAY));
            }
        }
        if (!MinecraftForge.EVENT_BUS.post((Event)(normalExtraTooltips = new ExtraTooltipEvent(stack, ExtraTooltipEvent.Type.NORMAL)))) {
            tooltip.addAll(normalExtraTooltips.getExtraTooltips());
        }
        if (KeybindsUtil.isKeyDownIgnoreConflicts((KeyMapping)sneak)) {
            ExtraTooltipEvent sneakExtraTooltips;
            if (ItemLevelProperties.getMaxLevel((ItemStack)stack) > 0) {
                tooltip.add(ItemLevelProperties.getLevelProgress((ItemStack)stack));
            }
            if (JetBootsProperties.hasEngineUpgrade(stack)) {
                tooltip.add(TranslationHelper.Translations.ENGINE_UPGRADE.get());
            }
            if (JetBootsProperties.hasThrusterUpgrade(stack)) {
                tooltip.add(TranslationHelper.Translations.THRUSTER_UPGRADE.get());
            }
            if (JetBootsProperties.hasShockUpgrade(stack)) {
                tooltip.add(TranslationHelper.Translations.SHOCK_ABSORBER_UPGRADE.get());
            }
            if (JetBootsProperties.hasMuffledUpgrade(stack)) {
                tooltip.add(TranslationHelper.Translations.MUFFLED_UPGRADE.get());
            }
            if (JetBootsProperties.hasUnderWaterUpgrade(stack)) {
                tooltip.add(TranslationHelper.Translations.UNDERWATER_UPGRADE.get());
            }
            if (this.isSoulbound(stack)) {
                tooltip.add(TranslationHelper.Translations.SOULBOUND.get(ChatFormatting.LIGHT_PURPLE));
            }
            if (!MinecraftForge.EVENT_BUS.post((Event)(sneakExtraTooltips = new ExtraTooltipEvent(stack, ExtraTooltipEvent.Type.SNEAKING)))) {
                tooltip.addAll(sneakExtraTooltips.getExtraTooltips());
            }
        } else {
            ExtraTooltipEvent notSneakExtraTooltips = new ExtraTooltipEvent(stack, ExtraTooltipEvent.Type.NOT_SNEAKING);
            if (!MinecraftForge.EVENT_BUS.post((Event)notSneakExtraTooltips)) {
                tooltip.addAll(notSneakExtraTooltips.getExtraTooltips());
            }
            tooltip.add(TranslationHelper.Translations.OPEN_CONTAINER.get(ChatFormatting.GRAY));
            tooltip.add(TranslationHelper.Translations.SHOW_MORE_INFO.get(ChatFormatting.GRAY, new Object[]{KeybindsUtil.getKeyBindText((KeyMapping)sneak)}));
        }
    }

    public boolean m_142522_(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY, null).orElse(null);
        return energy.getEnergyStored() < energy.getMaxEnergyStored();
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new JetbootsCapabilities(stack, (Integer)Config.DEFAULT_MAX_POWER.get());
    }

    public int m_142158_(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY, null).orElse(null);
        if (energy == null) {
            return 0;
        }
        double widthPercentage = 1.0 - (double)energy.getEnergyStored() / (double)energy.getMaxEnergyStored();
        return Math.round(13.0f - (float)widthPercentage * 13.0f);
    }

    public int m_142159_(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY, null).orElse(null);
        if (energy == null) {
            return super.m_142159_(stack);
        }
        return Mth.m_14169_((float)(Math.max(0.0f, (float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored()) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean m_5812_(ItemStack stack) {
        return false;
    }

    public int getMaxLevel() {
        return (Integer)Config.JETBOOTS_MAX_LEVEL.get();
    }
}

