/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.jetboots.common.items.equipment;

import com.black_dog20.bml.utils.keybinds.KeybindsUtil;
import com.black_dog20.bml.utils.leveling.ItemLevelProperties;
import com.black_dog20.bml.utils.translate.ITranslation;
import com.black_dog20.bml.utils.translate.TranslationUtil;
import com.black_dog20.jetboots.Config;
import com.black_dog20.jetboots.api.events.ExtraTooltipEvent;
import com.black_dog20.jetboots.client.containers.EnchantableItemContainer;
import com.black_dog20.jetboots.common.capabilities.GuardianCapabilities;
import com.black_dog20.jetboots.common.items.IBaseGuradianEquipment;
import com.black_dog20.jetboots.common.items.materials.GuardianTier;
import com.black_dog20.jetboots.common.util.TranslationHelper;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.Event;

public class GuardianSwordItem
extends SwordItem
implements IBaseGuradianEquipment {
    public GuardianSwordItem(Item.Properties builder) {
        super((Tier)GuardianTier.getInstance(), 0, 0.0f, builder.m_41503_(-1).setNoRepair());
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (slot == EquipmentSlot.MAINHAND) {
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "jetboots.damage", this.getCustomAttackDamage(stack), AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "jetboots.speed", this.getCustomAttackSpeed(stack), AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return builder.build();
    }

    private double getCustomAttackDamage(ItemStack stack) {
        return ItemLevelProperties.calculateValue((double)((Double)Config.SWORD_BASE_ATTACK_DAMAGE.get()), (double)((Double)Config.SWORD_MAX_ATTACK_DAMAGE.get()), (ItemStack)stack);
    }

    private double getCustomAttackSpeed(ItemStack stack) {
        return ItemLevelProperties.calculateValue((double)((Double)Config.SWORD_BASE_ATTACK_SPEED.get()), (double)((Double)Config.SWORD_MAX_ATTACK_SPEED.get()), (ItemStack)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        KeyMapping sneak = Minecraft.m_91087_().f_91066_.f_92090_;
        ExtraTooltipEvent normalExtraTooltips = new ExtraTooltipEvent(stack, ExtraTooltipEvent.Type.NORMAL);
        if (!MinecraftForge.EVENT_BUS.post((Event)normalExtraTooltips)) {
            tooltip.addAll(normalExtraTooltips.getExtraTooltips());
        }
        if (KeybindsUtil.isKeyDownIgnoreConflicts((KeyMapping)sneak)) {
            tooltip.addAll(this.getLevelTooltips(stack));
            ExtraTooltipEvent sneakExtraTooltips = new ExtraTooltipEvent(stack, ExtraTooltipEvent.Type.SNEAKING);
            if (!MinecraftForge.EVENT_BUS.post((Event)sneakExtraTooltips)) {
                tooltip.addAll(sneakExtraTooltips.getExtraTooltips());
            }
        } else {
            ExtraTooltipEvent notSneakExtraTooltips = new ExtraTooltipEvent(stack, ExtraTooltipEvent.Type.NOT_SNEAKING);
            if (!MinecraftForge.EVENT_BUS.post((Event)notSneakExtraTooltips)) {
                tooltip.addAll(notSneakExtraTooltips.getExtraTooltips());
            }
            tooltip.add((Component)TranslationUtil.translate((ITranslation)TranslationHelper.Translations.OPEN_CONTAINER, (ChatFormatting)ChatFormatting.GRAY));
            tooltip.add((Component)TranslationUtil.translate((ITranslation)TranslationHelper.Translations.SHOW_MORE_INFO, (ChatFormatting)ChatFormatting.GRAY, (Object[])new Object[]{KeybindsUtil.getKeyBindText((KeyMapping)sneak)}));
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new GuardianCapabilities(stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, final Player player, final InteractionHand hand) {
        if (player.m_6047_()) {
            if (!world.f_46443_) {
                player.m_5893_(new MenuProvider(){

                    public Component m_5446_() {
                        return player.m_21120_(hand).m_41786_();
                    }

                    @Nullable
                    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player2) {
                        return new EnchantableItemContainer(windowId, playerInventory, player2);
                    }
                });
            }
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
        }
        return super.m_7203_(world, player, hand);
    }

    public boolean m_41465_() {
        return false;
    }

    public boolean m_5812_(ItemStack stack) {
        return false;
    }

    public int getMaxLevel() {
        return (Integer)Config.SWORD_MAX_LEVEL.get();
    }
}

