/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.jetboots.common.items.equipment;

import com.black_dog20.bml.utils.keybinds.KeybindsUtil;
import com.black_dog20.bml.utils.leveling.ItemLevelProperties;
import com.black_dog20.bml.utils.translate.ITranslation;
import com.black_dog20.bml.utils.translate.TranslationUtil;
import com.black_dog20.jetboots.Config;
import com.black_dog20.jetboots.api.events.ExtraTooltipEvent;
import com.black_dog20.jetboots.client.keybinds.Keybinds;
import com.black_dog20.jetboots.common.capabilities.GuardianCapabilities;
import com.black_dog20.jetboots.common.items.BaseGuardianArmorItem;
import com.black_dog20.jetboots.common.items.materials.GuardianMaterial;
import com.black_dog20.jetboots.common.util.TranslationHelper;
import com.black_dog20.jetboots.common.util.properties.GuardinanHelmetProperties;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.Event;

public class GuardianHelmetItem
extends BaseGuardianArmorItem {
    public GuardianHelmetItem(Item.Properties builder) {
        super(GuardianMaterial.getInstance(), ArmorItem.Type.HELMET, builder.m_41503_(-1).setNoRepair());
    }

    @Override
    protected double getCustomDamageReduceAmount(ItemStack stack) {
        return GuardinanHelmetProperties.getMode(stack) ? ItemLevelProperties.calculateValue((double)((Double)Config.HELMET_BASE_DAMAGE_REDUCE_AMOUNT.get()), (double)((Double)Config.HELMET_MAX_DAMAGE_REDUCE_AMOUNT.get()), (ItemStack)stack) : 0.0;
    }

    @Override
    protected double getCustomToughness(ItemStack stack) {
        return GuardinanHelmetProperties.getMode(stack) ? ItemLevelProperties.calculateValue((double)((Double)Config.HELMET_BASE_TOUGHNESS_AMOUNT.get()), (double)((Double)Config.HELMET_MAX_TOUGHNESS_AMOUNT.get()), (ItemStack)stack) : 0.0;
    }

    @Override
    protected double getCustomKnockbackResistance(ItemStack stack) {
        return GuardinanHelmetProperties.getMode(stack) ? ItemLevelProperties.calculateValue((double)((Double)Config.HELMET_BASE_KNOCKBACK_RESISTANCE_AMOUNT.get()), (double)((Double)Config.HELMET_MAX_KNOCKBACK_RESISTANCE_AMOUNT.get()), (ItemStack)stack) : 0.0;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "jetboots:textures/armor/guardian_armor.png";
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        KeyMapping sneak = Minecraft.m_91087_().f_91066_.f_92090_;
        ExtraTooltipEvent normalExtraTooltips = new ExtraTooltipEvent(stack, ExtraTooltipEvent.Type.NORMAL);
        if (!MinecraftForge.EVENT_BUS.post((Event)normalExtraTooltips)) {
            tooltip.addAll(normalExtraTooltips.getExtraTooltips());
        }
        if (KeybindsUtil.isKeyDownIgnoreConflicts((KeyMapping)sneak)) {
            tooltip.add((Component)TranslationUtil.translate((ITranslation)TranslationHelper.Translations.HELMET_INFO, (ChatFormatting)ChatFormatting.GRAY));
            tooltip.addAll(this.getLevelTooltips(stack));
            ExtraTooltipEvent sneakExtraTooltips = new ExtraTooltipEvent(stack, ExtraTooltipEvent.Type.SNEAKING);
            if (!MinecraftForge.EVENT_BUS.post((Event)sneakExtraTooltips)) {
                tooltip.addAll(sneakExtraTooltips.getExtraTooltips());
            }
        } else {
            tooltip.add((Component)TranslationUtil.translate((ITranslation)TranslationHelper.Translations.CHANGE_HELMET_MODE, (ChatFormatting)ChatFormatting.GRAY, (Object[])new Object[]{KeybindsUtil.getKeyBindText((KeyMapping)Keybinds.keyHelmetMode)}));
            tooltip.add((Component)TranslationUtil.translate((ITranslation)TranslationHelper.Translations.CHANGE_HELMET_NIGHT_VISION, (ChatFormatting)ChatFormatting.GRAY, (Object[])new Object[]{KeybindsUtil.getKeyBindText((KeyMapping)Keybinds.keyHelmetVision)}));
            ExtraTooltipEvent notSneakExtraTooltips = new ExtraTooltipEvent(stack, ExtraTooltipEvent.Type.NOT_SNEAKING);
            if (!MinecraftForge.EVENT_BUS.post((Event)notSneakExtraTooltips)) {
                tooltip.addAll(notSneakExtraTooltips.getExtraTooltips());
            }
            tooltip.add((Component)TranslationUtil.translate((ITranslation)TranslationHelper.Translations.OPEN_CONTAINER, (ChatFormatting)ChatFormatting.GRAY));
            tooltip.add((Component)TranslationUtil.translate((ITranslation)TranslationHelper.Translations.SHOW_MORE_INFO, (ChatFormatting)ChatFormatting.GRAY, (Object[])new Object[]{KeybindsUtil.getKeyBindText((KeyMapping)sneak)}));
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new GuardianCapabilities(stack);
    }

    public boolean m_5812_(ItemStack stack) {
        return false;
    }

    public int getMaxLevel() {
        return (Integer)Config.HELMET_MAX_LEVEL.get();
    }
}

