/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.jetboots.common.events;

import com.black_dog20.bml.api.ILevelableItem;
import com.black_dog20.bml.event.PlayerMoveEvent;
import com.black_dog20.bml.utils.leveling.ItemLevelProperties;
import com.black_dog20.bml.utils.math.MathUtil;
import com.black_dog20.jetboots.Config;
import com.black_dog20.jetboots.common.items.BaseGuardianArmorItem;
import com.black_dog20.jetboots.common.items.equipment.GuardianSwordItem;
import com.black_dog20.jetboots.common.util.ModUtils;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jetboots")
public class XpHandler {
    @SubscribeEvent
    public static void onPlayerMoveFlying(PlayerMoveEvent event) {
        Player player = event.getEntity();
        if (player.m_9236_().f_46443_) {
            return;
        }
        if (!ModUtils.hasJetBoots(player) && ModUtils.isJetbootsFlying(player)) {
            return;
        }
        if (event.getDistance() < 0.9) {
            return;
        }
        if (XpHandler.getRemainingCooldown(player) > 0L) {
            return;
        }
        ItemStack jetboots = ModUtils.getJetBoots(player);
        ItemLevelProperties.addXp((Player)player, (ItemStack)jetboots, (int)((Integer)Config.FLIGHT_XP.get()));
        XpHandler.setCooldown(player);
    }

    private static void setCooldown(Player player) {
        CompoundTag compound = player.getPersistentData();
        compound.m_128356_("jetboots-flight-xp-cooldown", System.currentTimeMillis() / 1000L);
    }

    public static long getCooldown(Player player) {
        CompoundTag compound = player.getPersistentData();
        return compound.m_128454_("jetboots-flight-xp-cooldown");
    }

    public static long getRemainingCooldown(Player player) {
        long currentTime = System.currentTimeMillis() / 1000L;
        long cooldownStart = XpHandler.getCooldown(player);
        long remaining = (long)(Math.max((Integer)Config.TICKS_BETWEEN_FLIGHT_XP_GAIN.get(), 20) / 20) - (currentTime - cooldownStart);
        return remaining < 0L ? 0L : remaining;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerHurt(LivingHurtEvent event) {
        LivingEntity livingEntity;
        if (event.getAmount() > 0.0f && !event.getSource().m_269533_(DamageTypeTags.f_268490_) && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_9236_().f_46443_) {
                return;
            }
            Set levelableItems = player.m_150109_().f_35975_.stream().filter(stack -> stack.m_41720_() instanceof BaseGuardianArmorItem).filter(stack -> stack.m_41720_() instanceof ILevelableItem).collect(Collectors.toSet());
            int xp = (int)Math.ceil(MathUtil.clamp((double)((double)event.getAmount() * (Double)Config.HURT_XP_MODIFIER.get()), (double)((Double)Config.HURT_XP_MIN.get()), (double)((Double)Config.HURT_XP_MAX.get())));
            for (ItemStack stack2 : levelableItems) {
                ItemLevelProperties.addXp((Player)player, (ItemStack)stack2, (int)xp);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerAttackEntity(LivingAttackEvent event) {
        if (event.getAmount() > 0.0f && !event.getSource().m_269533_(DamageTypeTags.f_268490_) && event.getSource().m_276093_(DamageTypes.f_268464_)) {
            if (event.getSource().m_7639_() == null) {
                return;
            }
            Entity entity = event.getSource().m_7639_();
            if (!(entity instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            if (player.m_9236_().f_46443_) {
                return;
            }
            ItemStack weapon = player.m_21205_();
            if (weapon.m_41720_() instanceof ILevelableItem && weapon.m_41720_() instanceof GuardianSwordItem) {
                int xp = (int)Math.ceil(MathUtil.clamp((double)((double)event.getAmount() * (Double)Config.ATTACK_XP_MODIFIER.get()), (double)((Double)Config.ATTACK_XP_MIN.get()), (double)((Double)Config.ATTACK_XP_MAX.get())));
                ItemLevelProperties.addXp((Player)player, (ItemStack)weapon, (int)xp);
            }
        }
    }
}

