/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.jetboots.common.events;

import com.black_dog20.bml.event.ArmorEvent;
import com.black_dog20.bml.utils.leveling.ItemLevelProperties;
import com.black_dog20.bml.utils.math.MathUtil;
import com.black_dog20.bml.utils.player.MovementUtil;
import com.black_dog20.jetboots.Config;
import com.black_dog20.jetboots.common.items.ModItems;
import com.black_dog20.jetboots.common.network.PacketHandler;
import com.black_dog20.jetboots.common.network.packets.PacketAwardRocketBootXp;
import com.black_dog20.jetboots.common.network.packets.PacketSyncRocketFlight;
import com.black_dog20.jetboots.common.util.ModUtils;
import com.black_dog20.jetboots.common.util.properties.RocketBootsProperties;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jetboots", value={Dist.CLIENT})
public class RocketFlightHandler {
    public static Map<UUID, RocketBootsPower> playerGlidePowerMap = new ConcurrentHashMap<UUID, RocketBootsPower>();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGlidebootsTick(ArmorEvent.Tick event) {
        Player player = event.player;
        if (event.isArmorEqualTo((Item)ModItems.ROCKET_BOOTS.get()) && event.phase == TickEvent.Phase.END) {
            RocketBootsPower rocketBootsPower = playerGlidePowerMap.computeIfAbsent(player.m_20148_(), RocketBootsPower::new);
            --rocketBootsPower.cooldown;
            if (rocketBootsPower.cooldown < 0) {
                rocketBootsPower.resetCoolDown();
            } else {
                rocketBootsPower.tick(player);
            }
        }
    }

    public static class RocketBootsPower {
        private final UUID uuid;
        public int cooldown = 20;
        private int tickFlight = 0;
        private int xpCounter = 0;

        public RocketBootsPower(UUID uuid) {
            this.uuid = uuid;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public int getMaxFlightTime(ItemStack stack) {
            return (int)(ItemLevelProperties.calculateValue((double)((Integer)Config.ROCKETBOOTS_BASE_FLIGHT_TIME.get()).intValue(), (double)((Integer)Config.ROCKETBOOTS_MAX_FLIGHT_TIME.get()).intValue(), (ItemStack)stack) * 2.0);
        }

        public int getTickFlight() {
            return this.tickFlight;
        }

        public void resetCoolDown() {
            this.cooldown = 20;
        }

        public void tick(Player player) {
            if (player == null) {
                return;
            }
            if (!ModUtils.hasRocketBoots(player)) {
                return;
            }
            ItemStack rocketboots = ModUtils.getRocketBoots(player);
            if (!RocketBootsProperties.getEngineState(rocketboots)) {
                return;
            }
            boolean onGround = player.m_20096_();
            boolean isJumping = Minecraft.m_91087_().f_91066_.f_92089_.m_90857_();
            if (!onGround && isJumping && !player.m_20069_()) {
                if (this.tickFlight < this.getMaxFlightTime(rocketboots)) {
                    ++this.tickFlight;
                    ++this.xpCounter;
                    player.f_19789_ = 0.0f;
                    double motion_y = player.m_20184_().f_82480_;
                    MovementUtil.jetpackFly((Player)player, (double)(motion_y * 0.9 + 0.1));
                    MovementUtil.speedUp((Player)player, (double)0.03, (double)1.0);
                    PacketHandler.sendToServer(new PacketSyncRocketFlight(true));
                } else {
                    PacketHandler.sendToServer(new PacketSyncRocketFlight(false));
                    this.awardXp();
                }
            }
            if ((!isJumping || player.m_20069_()) && this.tickFlight > 0) {
                --this.tickFlight;
                PacketHandler.sendToServer(new PacketSyncRocketFlight(false));
                this.awardXp();
            }
        }

        private void awardXp() {
            if (this.xpCounter != 0) {
                double xp = MathUtil.clamp((double)((double)this.xpCounter * (Double)Config.ROCKET_XP_MODIFIER.get()), (double)((Integer)Config.ROCKET_XP_MIN.get()).intValue(), (double)((Integer)Config.ROCKET_XP_MAX.get()).intValue());
                PacketHandler.sendToServer(new PacketAwardRocketBootXp((int)xp));
                this.xpCounter = 0;
            }
        }
    }
}

