/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.jetboots.common.events;

import com.black_dog20.bml.event.ArmorEvent;
import com.black_dog20.jetboots.common.items.ModItems;
import com.black_dog20.jetboots.common.util.ModUtils;
import com.black_dog20.jetboots.common.util.properties.GuardinanHelmetProperties;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jetboots")
public class HelmetHandler {
    private static final Set<MobEffect> HELMET_EFFECTS_REMOVED = ImmutableSet.of((Object)MobEffects.f_19615_);

    private static boolean doesHelmetProtectAgainst(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268722_) || source.m_276093_(DamageTypes.f_268493_);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerAttack(LivingAttackEvent event) {
        ItemStack helmet;
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && ModUtils.hasGuardianHelmet(player = (Player)livingEntity) && GuardinanHelmetProperties.getMode(helmet = ModUtils.getGuardianHelmet(player)) && HelmetHandler.doesHelmetProtectAgainst(event.getSource())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerHurt(LivingHurtEvent event) {
        ItemStack helmet;
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && ModUtils.hasGuardianHelmet(player = (Player)livingEntity) && GuardinanHelmetProperties.getMode(helmet = ModUtils.getGuardianHelmet(player)) && HelmetHandler.doesHelmetProtectAgainst(event.getSource())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingUpdatePlayer(TickEvent.PlayerTickEvent event) {
        Player player;
        if (!event.player.m_9236_().f_46443_ && ModUtils.hasGuardianHelmet(player = event.player) && GuardinanHelmetProperties.getMode(ModUtils.getGuardianHelmet(player))) {
            if (player.m_20069_()) {
                player.m_20301_(player.m_6062_());
            }
            HELMET_EFFECTS_REMOVED.stream().filter(arg_0 -> ((Player)player).m_21023_(arg_0)).forEach(arg_0 -> ((Player)player).m_21195_(arg_0));
        }
    }

    @SubscribeEvent
    public static void playerBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.getEntity() != null) {
            Player player = event.getEntity();
            ItemStack tool = player.m_21205_();
            float toolSpeed = tool.m_41720_().m_8102_(tool, event.getState());
            if (ModUtils.hasGuardianHelmet(player) && player.m_20069_()) {
                if (toolSpeed > event.getOriginalSpeed()) {
                    if (player.m_20096_()) {
                        event.setNewSpeed(event.getOriginalSpeed() * 5.0f);
                    } else {
                        event.setNewSpeed(event.getOriginalSpeed() * 25.0f);
                    }
                }
            } else if (ModUtils.isJetbootsFlying(player) && !player.m_20096_() && toolSpeed > event.getOriginalSpeed()) {
                event.setNewSpeed(event.getOriginalSpeed() * 5.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onUnequipHelmet(ArmorEvent.Unequip event) {
        Player player = event.player;
        ItemStack helmet = event.armor;
        if (event.isArmorEqualTo((Item)ModItems.GUARDIAN_HELMET.get()) && GuardinanHelmetProperties.getNightVision(helmet)) {
            player.m_21195_(MobEffects.f_19611_);
        }
    }

    @SubscribeEvent
    public static void onHelmetTick(ArmorEvent.Tick event) {
        Player player = event.player;
        ItemStack helmet = event.armor;
        if (event.side.isClient()) {
            return;
        }
        if (event.isArmorEqualTo((Item)ModItems.GUARDIAN_HELMET.get())) {
            if (GuardinanHelmetProperties.getNightVision(helmet) && GuardinanHelmetProperties.getMode(helmet)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, Short.MAX_VALUE, 0, false, false, false));
                player.getPersistentData().m_128379_("guardian_helmet_night_vision", true);
            } else if (player.getPersistentData().m_128471_("guardian_helmet_night_vision")) {
                player.getPersistentData().m_128473_("guardian_helmet_night_vision");
                player.m_21195_(MobEffects.f_19611_);
            }
        }
    }
}

