/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.jetboots.common.events;

import com.black_dog20.bml.event.ArmorEvent;
import com.black_dog20.bml.utils.player.MovementUtil;
import com.black_dog20.jetboots.common.items.ModItems;
import com.black_dog20.jetboots.common.network.PacketHandler;
import com.black_dog20.jetboots.common.network.packets.PacketSyncPartical;
import com.black_dog20.jetboots.common.network.packets.PacketSyncSound;
import com.black_dog20.jetboots.common.network.packets.PacketSyncStopSound;
import com.black_dog20.jetboots.common.util.EnergyUtil;
import com.black_dog20.jetboots.common.util.ModUtils;
import com.black_dog20.jetboots.common.util.properties.JetBootsProperties;
import com.black_dog20.jetboots.common.util.properties.RocketBootsProperties;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="jetboots")
public class FlyingHandler {
    @SubscribeEvent
    public static void onEquipJetboots(ArmorEvent.Equip event) {
        Player player = event.player;
        if (event.isArmorEqualTo((Item)ModItems.JET_BOOTS.get()) && ModUtils.canFlyWithJetboots(player)) {
            player.m_150110_().f_35936_ = true;
            player.m_6885_();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onJetbootsTick(ArmorEvent.Tick event) {
        Player player = event.player;
        ItemStack jetboots = event.armor;
        if (event.isArmorEqualTo((Item)ModItems.JET_BOOTS.get())) {
            if (event.phase == TickEvent.Phase.END) {
                if (ModUtils.canUseElytraFlight(player)) {
                    player.m_36320_();
                }
                return;
            }
            if (ModUtils.canFlyWithJetboots(player)) {
                if (!(player.m_150110_().f_35936_ || ModUtils.useElytraFlight(player, jetboots) || player.m_21255_())) {
                    player.m_150110_().f_35936_ = true;
                    player.m_6885_();
                }
                if (ModUtils.useElytraFlight(player, jetboots)) {
                    if (event.side == LogicalSide.SERVER) {
                        FlyingHandler.drawpower(player, jetboots);
                    }
                    FlyingHandler.doElytraFlight(player, jetboots);
                } else if (player.m_21255_()) {
                    FlyingHandler.stopElytraFlight(player);
                } else if (player.m_150110_().f_35935_ && event.side == LogicalSide.SERVER) {
                    FlyingHandler.drawpower(player, jetboots);
                }
                FlyingHandler.sendSoundAndPartical(event, player, jetboots);
            } else {
                player.m_150110_().f_35936_ = false;
                player.m_150110_().f_35935_ = false;
                player.m_6885_();
                if (player.m_21255_()) {
                    FlyingHandler.stopElytraFlight(player);
                }
                if (event.side == LogicalSide.SERVER) {
                    PacketHandler.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new PacketSyncStopSound(player.m_20148_()));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onUnequipJetboots(ArmorEvent.Unequip event) {
        Player player = event.player;
        if (event.isArmorEqualTo((Item)ModItems.JET_BOOTS.get())) {
            FlyingHandler.stopElytraFlight(player);
            PacketHandler.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new PacketSyncStopSound(player.m_20148_()));
            if (!player.m_7500_()) {
                player.m_150110_().f_35936_ = false;
                player.m_150110_().f_35935_ = false;
            }
            player.m_6885_();
        }
    }

    private static void sendSoundAndPartical(ArmorEvent.Tick event, Player player, ItemStack jetboots) {
        if (event.side == LogicalSide.SERVER) {
            if (ModUtils.isJetbootsFlying(player) && ModUtils.canFlyWithJetboots(player)) {
                PacketHandler.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new PacketSyncPartical(player.m_20148_(), player.m_150110_().f_35935_));
                if (!JetBootsProperties.hasActiveMuffledUpgrade(jetboots)) {
                    if (!player.m_20069_()) {
                        PacketHandler.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new PacketSyncSound(player.m_20148_()));
                    } else {
                        PacketHandler.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new PacketSyncStopSound(player.m_20148_()));
                    }
                }
            } else {
                PacketHandler.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new PacketSyncStopSound(player.m_20148_()));
            }
        }
    }

    private static void stopElytraFlight(Player player) {
        player.m_36321_();
        player.m_150110_().f_35936_ = true;
        if (ModUtils.isBlocksOverGround(player, 2.9, 4)) {
            player.m_150110_().f_35935_ = true;
        }
        player.m_6885_();
    }

    private static void doElytraFlight(Player player, ItemStack jetboots) {
        if (player.m_150110_().f_35936_ || player.m_150110_().f_35935_) {
            player.m_150110_().f_35936_ = false;
            player.m_150110_().f_35935_ = false;
            player.m_6885_();
        }
        player.m_36320_();
        double speed = FlyingHandler.getSpeed(player, jetboots);
        MovementUtil.speedUpElytraFlight((Player)player, (double)speed, (double)0.1, (double)0.5);
    }

    private static void drawpower(Player player, ItemStack jetboots) {
        if (!player.m_7500_()) {
            jetboots.getCapability(ForgeCapabilities.ENERGY, null).ifPresent(e -> EnergyUtil.extractOrReceive(e, EnergyUtil.getEnergyWhileFlying(jetboots)));
        }
    }

    private static double getSpeed(Player player, ItemStack jetboots) {
        boolean inWater = player.m_20069_();
        if (JetBootsProperties.hasThrusterUpgrade(jetboots) && JetBootsProperties.getSpeed(jetboots)) {
            return inWater ? 1.5 : 3.0;
        }
        return inWater ? 0.5 : 1.5;
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (ModUtils.hasJetBoots(player) && JetBootsProperties.hasShockUpgrade(ModUtils.getJetBoots(player))) {
                event.setCanceled(true);
            }
            if (ModUtils.hasRocketBoots(player) && RocketBootsProperties.hasShockUpgrade(ModUtils.getRocketBoots(player))) {
                event.setCanceled(true);
            }
        }
    }
}

