/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.jetboots.common.compat.refinedstorage.util;

import com.black_dog20.bml.utils.dimension.DimensionUtil;
import com.black_dog20.bml.utils.item.NBTUtil;
import com.black_dog20.bml.utils.math.Pos3D;
import com.black_dog20.jetboots.common.compat.refinedstorage.grids.WirelessCraftingUpgradeGridFactory;
import com.black_dog20.jetboots.common.util.TranslationHelper;
import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.INetworkNodeGraphEntry;
import com.refinedmods.refinedstorage.api.network.IWirelessTransmitter;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.inventory.player.PlayerSlot;
import com.refinedmods.refinedstorage.util.LevelUtils;
import com.refinedmods.refinedstorage.util.NetworkUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class RefinedStorageCompatUtil {
    public static void openNetwork(MinecraftServer server, ItemStack helmet, Player player) {
        ServerLevel nodeWorld;
        INetwork network;
        ResourceKey<Level> dimension = RefinedStorageCompatUtil.getDimension(helmet);
        if (!RefinedStorageCompatUtil.isValid(helmet)) {
            player.m_213846_(TranslationHelper.Compat.NOT_LINKED_TO_NETWORK.get());
            return;
        }
        if (RefinedStorageCompatUtil.isValid(helmet) && dimension != null && server.m_129880_(dimension) != null && (network = NetworkUtils.getNetworkFromNode((INetworkNode)NetworkUtils.getNodeFromBlockEntity((BlockEntity)(nodeWorld = server.m_129880_(dimension)).m_7702_(new BlockPos(RefinedStorageCompatUtil.getX(helmet), RefinedStorageCompatUtil.getY(helmet), RefinedStorageCompatUtil.getZ(helmet)))))) != null) {
            if (!network.getSecurityManager().hasPermission(Permission.MODIFY, player)) {
                LevelUtils.sendNoPermissionMessage((Player)player);
                return;
            }
            boolean inRange = network.getNodeGraph().all().stream().map(INetworkNodeGraphEntry::getNode).filter(IWirelessTransmitter.class::isInstance).anyMatch(n -> RefinedStorageCompatUtil.sameDimensionAndInRange(n, network, helmet, player));
            if (!inRange) {
                player.m_213846_(TranslationHelper.Compat.RS_OUT_OF_RANGE.get());
                return;
            }
            API.instance().getGridManager().openGrid(WirelessCraftingUpgradeGridFactory.ID, (ServerPlayer)player, helmet, new PlayerSlot(-1));
            return;
        }
        player.m_213846_(TranslationHelper.Compat.RS_NETWORK_NOT_FOUND.get());
    }

    private static boolean sameDimensionAndInRange(INetworkNode node, INetwork network, ItemStack helmet, Player player) {
        if (!(node instanceof IWirelessTransmitter)) {
            return false;
        }
        if (!node.isActive() || !network.canRun()) {
            return false;
        }
        IWirelessTransmitter transmitter = (IWirelessTransmitter)node;
        if (transmitter.getDimension() != DimensionUtil.getDimension((Level)player.m_20193_())) {
            return false;
        }
        Vec3 pos = player.m_20182_();
        Pos3D transmitterPos = new Pos3D((Vec3i)transmitter.getOrigin());
        int extraRange = RefinedStorageCompatUtil.getRange(helmet);
        return transmitterPos.distance(pos) < (double)(transmitter.getRange() + extraRange);
    }

    public static int getRange(ItemStack helmet) {
        int baseRange = RS.SERVER_CONFIG.getWirelessTransmitter().getBaseRange();
        int rangePerUpgrade = RS.SERVER_CONFIG.getWirelessTransmitter().getRangePerUpgrade();
        int upgradeCount = Math.min(NBTUtil.getInt((ItemStack)helmet, (String)"jetboots-compat-upgrade-wireless-range"), 4);
        return baseRange + upgradeCount * rangePerUpgrade;
    }

    public static boolean isValid(ItemStack stack) {
        CompoundTag compoundNBT = stack.m_41784_();
        return compoundNBT.m_128441_("NodeX") && compoundNBT.m_128441_("NodeY") && compoundNBT.m_128441_("NodeZ") && compoundNBT.m_128441_("Dimension");
    }

    public static ResourceKey<Level> getDimension(ItemStack stack) {
        ResourceLocation name;
        CompoundTag compoundNBT = stack.m_41784_();
        if (compoundNBT.m_128441_("Dimension") && (name = ResourceLocation.m_135820_((String)compoundNBT.m_128461_("Dimension"))) != null) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)name);
        }
        return null;
    }

    public static int getX(ItemStack stack) {
        return NBTUtil.getInt((ItemStack)stack, (String)"NodeX");
    }

    public static int getY(ItemStack stack) {
        return NBTUtil.getInt((ItemStack)stack, (String)"NodeY");
    }

    public static int getZ(ItemStack stack) {
        return NBTUtil.getInt((ItemStack)stack, (String)"NodeZ");
    }
}

