/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.jetboots.common.compat.refinedstorage.network;

import com.black_dog20.jetboots.common.compat.refinedstorage.network.packets.PacketOpenCraftingGrid;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class RSCompatPacketHandler {
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    private static short index = 0;
    public static final SimpleChannel NETWORK = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("jetboots", "rs_compat")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();

    public static void register() {
        RSCompatPacketHandler.registerMessage(PacketOpenCraftingGrid.class, PacketOpenCraftingGrid::encode, PacketOpenCraftingGrid::decode, PacketOpenCraftingGrid.Handler::handle);
    }

    public static void sendTo(Object msg, ServerPlayer player) {
        if (!(player instanceof FakePlayer)) {
            NETWORK.sendTo(msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static void sendToAll(Object msg, Level world) {
        for (Player player : world.m_6907_()) {
            if (player instanceof FakePlayer) continue;
            NETWORK.sendTo(msg, ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static void sendToServer(Object msg) {
        NETWORK.sendToServer(msg);
    }

    private static <MSG> void registerMessage(Class<MSG> messageType, BiConsumer<MSG, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> messageConsumer) {
        NETWORK.registerMessage((int)index, messageType, encoder, decoder, messageConsumer);
        index = (short)(index + 1);
        if (index > 255) {
            throw new RuntimeException("Too many messages!");
        }
    }
}

