/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.jetboots.common.compat.refinedstorage.grids;

import com.black_dog20.jetboots.common.compat.refinedstorage.RefinedStorageCompat;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.api.network.grid.ICraftingGridListener;
import com.refinedmods.refinedstorage.api.network.grid.INetworkAwareGrid;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.api.util.IStackList;
import com.refinedmods.refinedstorage.blockentity.grid.WirelessGrid;
import com.refinedmods.refinedstorage.container.transfer.TransferManager;
import com.refinedmods.refinedstorage.inventory.player.PlayerSlot;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class WirelessCraftingGrid
extends WirelessGrid {
    private final MinecraftServer server;
    private final Level world;
    private Set<ICraftingGridListener> listeners = new HashSet<ICraftingGridListener>();
    private AbstractContainerMenu craftingContainer = new AbstractContainerMenu(null, 0){
        protected final TransferManager transferManager;
        {
            this.transferManager = new TransferManager((AbstractContainerMenu)this);
        }

        public boolean m_6875_(Player player) {
            return false;
        }

        public ItemStack m_7648_(Player pPlayer, int pIndex) {
            return this.transferManager.transfer(pIndex);
        }

        public void m_6199_(Container inventory) {
            if (WirelessCraftingGrid.this.server != null) {
                WirelessCraftingGrid.this.onCraftingMatrixChanged();
            }
        }
    };
    private CraftingRecipe currentRecipe;
    private CraftingContainer matrix = new TransientCraftingContainer(this.craftingContainer, 3, 3);
    private ResultContainer result = new ResultContainer();

    public WirelessCraftingGrid(ItemStack stack, Level world, MinecraftServer server, PlayerSlot slot) {
        super(stack, server, slot);
        this.server = server;
        this.world = world;
        if (stack.m_41782_()) {
            StackUtils.readItems((Container)this.matrix, (int)1, (CompoundTag)stack.m_41783_());
        }
    }

    public Component getTitle() {
        return Component.m_237115_((String)"gui.refinedstorage.crafting_grid");
    }

    public GridType getGridType() {
        return GridType.CRAFTING;
    }

    public CraftingContainer getCraftingMatrix() {
        return this.matrix;
    }

    public ResultContainer getCraftingResult() {
        return this.result;
    }

    public void onCraftingMatrixChanged() {
        if (this.currentRecipe == null || !this.currentRecipe.m_5818_((Container)this.matrix, this.world)) {
            this.currentRecipe = this.world.m_7465_().m_44015_(RecipeType.f_44107_, (Container)this.matrix, this.world).orElse(null);
        }
        if (this.currentRecipe == null) {
            this.result.m_6836_(0, ItemStack.f_41583_);
        } else {
            this.result.m_6836_(0, this.currentRecipe.m_5874_((Container)this.matrix, this.world.m_9598_()));
        }
        this.listeners.forEach(ICraftingGridListener::onCraftingMatrixChanged);
        if (!this.getStack().m_41782_()) {
            this.getStack().m_41751_(new CompoundTag());
        }
        StackUtils.writeItems((Container)this.matrix, (int)1, (CompoundTag)this.getStack().m_41783_());
    }

    public void onCrafted(Player player, IStackList<ItemStack> availableItems, IStackList<ItemStack> usedItems) {
        RefinedStorageCompat.RSAPI.getCraftingGridBehavior().onCrafted((INetworkAwareGrid)this, this.currentRecipe, player, availableItems, usedItems);
        INetwork network = this.getNetwork();
        if (network != null) {
            network.getNetworkItemManager().drainEnergy(player, 1);
        }
    }

    public void onClear(Player player) {
        INetwork network = this.getNetwork();
        if (network != null && network.getSecurityManager().hasPermission(Permission.INSERT, player)) {
            for (int i = 0; i < this.matrix.m_6643_(); ++i) {
                ItemStack slot = this.matrix.m_8020_(i);
                if (slot.m_41619_()) continue;
                this.matrix.m_6836_(i, network.insertItem(slot, slot.m_41613_(), Action.PERFORM));
                network.getItemStorageTracker().changed(player, (Object)slot.m_41777_());
            }
            network.getNetworkItemManager().drainEnergy(player, 10);
        }
    }

    public void onCraftedShift(Player player) {
        RefinedStorageCompat.RSAPI.getCraftingGridBehavior().onCraftedShift((INetworkAwareGrid)this, player);
    }

    public void onRecipeTransfer(Player player, ItemStack[][] recipe) {
        RefinedStorageCompat.RSAPI.getCraftingGridBehavior().onRecipeTransfer((INetworkAwareGrid)this, player, recipe);
    }

    public void addCraftingListener(ICraftingGridListener listener) {
        this.listeners.add(listener);
    }

    public void removeCraftingListener(ICraftingGridListener listener) {
        this.listeners.remove(listener);
    }
}

