/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.jetboots.common.capabilities;

import com.black_dog20.jetboots.common.util.objects.EnchantableItemHandler;
import com.black_dog20.jetboots.common.util.objects.EnergyItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;

public class JetbootsCapabilities
implements ICapabilityProvider {
    private ItemStack jetboots;
    private int energyCapacity;
    private LazyOptional<IEnergyStorage> capability = LazyOptional.of(() -> new EnergyItem(this.jetboots, this.energyCapacity));
    private LazyOptional<IItemHandler> optional = LazyOptional.of(() -> new EnchantableItemHandler(this.jetboots));

    public JetbootsCapabilities(ItemStack stack, int energyCapacity) {
        this.jetboots = stack;
        this.energyCapacity = energyCapacity;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == null) {
            return LazyOptional.empty();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.optional.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.capability.cast();
        }
        return LazyOptional.empty();
    }
}

