/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.jetboots.client.screens;

import com.black_dog20.bml.api.ILevelableItem;
import com.black_dog20.bml.utils.leveling.ItemLevelProperties;
import com.black_dog20.bml.utils.math.MathUtil;
import com.black_dog20.bml.utils.text.TextComponentBuilder;
import com.black_dog20.bml.utils.translate.ITranslation;
import com.black_dog20.bml.utils.translate.TranslationUtil;
import com.black_dog20.jetboots.client.containers.EnchantableItemContainer;
import com.black_dog20.jetboots.common.items.ModItems;
import com.black_dog20.jetboots.common.network.PacketHandler;
import com.black_dog20.jetboots.common.network.packets.PacketUpdateMuffledMode;
import com.black_dog20.jetboots.common.util.TranslationHelper;
import com.black_dog20.jetboots.common.util.properties.JetBootsProperties;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class EnchantableItemScreen
extends AbstractContainerScreen<EnchantableItemContainer> {
    private final ResourceLocation GUI = new ResourceLocation("jetboots", "textures/gui/container_gui.png");
    private final Inventory inventory;
    private static final Button.CreateNarration DEFAULT_NARRATION = Supplier::get;

    public EnchantableItemScreen(EnchantableItemContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
        this.inventory = playerInventory;
    }

    protected void m_7856_() {
        super.m_7856_();
        ItemStack container = this.inventory.m_36056_();
        if (container.m_41720_() == ModItems.JET_BOOTS.get()) {
            ExtendedButton icon = new ExtendedButton(this.f_96543_ / 2 + 70, this.f_96544_ / 2 - 80, 10, 10, (Component)Component.m_237113_((String)"I"), this::onIconPress, DEFAULT_NARRATION);
            this.m_142416_((GuiEventListener)icon);
            if (JetBootsProperties.hasMuffledUpgrade(container)) {
                ExtendedButton muffled = new ExtendedButton(this.f_96543_ / 2 + 40, this.f_96544_ / 2 - 40, 40, 10, this.getMuffledText(!JetBootsProperties.hasActiveMuffledUpgrade(container)), this::onMuffledPress, DEFAULT_NARRATION);
                this.m_142416_((GuiEventListener)muffled);
            }
        }
    }

    private void onIconPress(Button p_onPress_1) {
        Minecraft.m_91087_().f_91074_.f_108617_.m_246623_("bml overlayConfig");
        this.m_7861_();
    }

    private void onMuffledPress(Button p_onPress_1) {
        boolean current = !JetBootsProperties.hasActiveMuffledUpgrade(this.inventory.m_36056_());
        PacketHandler.sendToServer(new PacketUpdateMuffledMode());
        p_onPress_1.m_93666_(this.getMuffledText(!current));
    }

    private Component getMuffledText(boolean on) {
        return TextComponentBuilder.of((String)"\u266a").with(":").space().with((ITranslation)TranslationHelper.Translations.ON, (ITranslation)TranslationHelper.Translations.OFF, () -> on).build();
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(pGuiGraphics, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int mouseX, int mouseY) {
        Objects.requireNonNull(this.f_96547_);
        int fontHeight = 9;
        pGuiGraphics.m_280614_(this.f_96547_, this.inventory.m_5446_(), 8, 58, 0x404040, false);
        pGuiGraphics.m_280614_(this.f_96547_, this.m_96636_(), 8, 6, 0x404040, false);
        ItemStack container = this.inventory.m_36056_();
        Optional.ofNullable(container).filter(stack -> stack.m_41720_() instanceof ILevelableItem).filter(stack -> ItemLevelProperties.getMaxLevel((ItemStack)stack) > 0).ifPresent(i -> pGuiGraphics.m_280614_(this.f_96547_, ItemLevelProperties.getLevelProgress((ItemStack)container, (ChatFormatting)ChatFormatting.DARK_GRAY), 8, 6 + fontHeight + 2, 0x404040, false));
        Optional.ofNullable(container).ifPresent(i -> i.getCapability(ForgeCapabilities.ENERGY, null).ifPresent(energy -> {
            MutableComponent energyText = TranslationUtil.translate((ITranslation)TranslationHelper.Translations.STORED_ENERGY, (ChatFormatting)ChatFormatting.GREEN, (Object[])new Object[]{MathUtil.formatThousands((int)energy.getEnergyStored()), MathUtil.formatThousands((int)energy.getMaxEnergyStored())});
            pGuiGraphics.m_280614_(this.f_96547_, (Component)energyText, 8, 6 + 2 * (fontHeight + 2), 0x404040, false);
        }));
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        pGuiGraphics.m_280218_(this.GUI, relX, relY, 0, 0, this.f_97726_, this.f_97727_);
    }
}

