/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.jetboots.client.renders;

import com.black_dog20.jetboots.common.items.ModItems;
import com.black_dog20.jetboots.common.util.properties.GuardinanHelmetProperties;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class GuardianLayerRender<T extends Player, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("jetboots", "textures/layers/guardian_layer.png");
    private final PlayerModel<T> model;
    private final ModelStateHolder headWear = new ModelStateHolder();
    private final ModelStateHolder bodyWear = new ModelStateHolder();
    private final ModelStateHolder rightArmWear = new ModelStateHolder();
    private final ModelStateHolder leftArmWear = new ModelStateHolder();
    private final ModelStateHolder rightLegWear = new ModelStateHolder();
    private final ModelStateHolder leftLegWear = new ModelStateHolder();

    public GuardianLayerRender(RenderLayerParent<T, M> renderer, EntityModelSet entityModelSet, boolean smallArms) {
        super(renderer);
        this.model = new PlayerModel(entityModelSet.m_171103_(smallArms ? ModelLayers.f_171166_ : ModelLayers.f_171162_), smallArms);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void render(@Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int packedLight, @Nonnull T entitylivingbase, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.prepareModel((Player)entitylivingbase, this.model);
        if (this.shouldRender((Player)entitylivingbase)) {
            this.model.f_102817_ = entitylivingbase.m_6047_();
            matrixStack.m_85836_();
            ((HumanoidModel)this.m_117386_()).m_102872_(this.model);
            this.model.m_6973_(entitylivingbase, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            ((HumanoidModel)this.m_117386_()).m_102872_(this.model);
            VertexConsumer ivertexbuilder = ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)this.model.m_103119_(TEXTURE), (boolean)false, (boolean)false);
            this.model.m_7695_(matrixStack, ivertexbuilder, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.m_85849_();
        }
    }

    private boolean shouldRender(Player entitylivingbase) {
        return GuardianLayerRender.hasHelmet(entitylivingbase) || GuardianLayerRender.hasJacket(entitylivingbase) || GuardianLayerRender.hasPants(entitylivingbase);
    }

    private void prepareModel(Player entitylivingbase, PlayerModel<T> model) {
        boolean hasHelmet = GuardianLayerRender.hasHelmet(entitylivingbase);
        boolean hasJacket = GuardianLayerRender.hasJacket(entitylivingbase);
        boolean hasPants = GuardianLayerRender.hasPants(entitylivingbase);
        model.f_102808_.f_104207_ = hasHelmet;
        model.f_102809_.f_104207_ = hasHelmet;
        model.f_102810_.f_104207_ = hasJacket;
        model.f_102811_.f_104207_ = hasJacket;
        model.f_102812_.f_104207_ = hasJacket;
        model.f_102813_.f_104207_ = hasPants;
        model.f_102814_.f_104207_ = hasPants;
    }

    private static boolean hasHelmet(Player entitylivingbase) {
        ItemStack helmet = entitylivingbase.m_6844_(EquipmentSlot.HEAD);
        return helmet.m_41720_() == ModItems.GUARDIAN_HELMET.get() && GuardinanHelmetProperties.getMode(helmet);
    }

    private static boolean hasJacket(Player entitylivingbase) {
        return entitylivingbase.m_6844_(EquipmentSlot.CHEST).m_41720_() == ModItems.GUARDIAN_JACKET.get();
    }

    private static boolean hasPants(Player entitylivingbase) {
        return entitylivingbase.m_6844_(EquipmentSlot.LEGS).m_41720_() == ModItems.GUARDIAN_PANTS.get();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void renderPlayerPre(RenderPlayerEvent.Pre event) {
        Player playerEntity = event.getEntity();
        PlayerModel playerModel = (PlayerModel)event.getRenderer().m_7200_();
        if (GuardianLayerRender.hasHelmet(playerEntity)) {
            this.headWear.update(playerModel.f_102809_);
        }
        if (GuardianLayerRender.hasJacket(playerEntity)) {
            this.bodyWear.update(playerModel.f_103378_);
            this.rightArmWear.update(playerModel.f_103375_);
            this.leftArmWear.update(playerModel.f_103374_);
        }
        if (GuardianLayerRender.hasPants(playerEntity)) {
            this.rightLegWear.update(playerModel.f_103377_);
            this.leftLegWear.update(playerModel.f_103376_);
        }
    }

    @SubscribeEvent
    public void renderPlayerPost(RenderPlayerEvent.Post event) {
        PlayerModel playerModel = (PlayerModel)event.getRenderer().m_7200_();
        this.headWear.restore(playerModel.f_102809_);
        this.bodyWear.restore(playerModel.f_103378_);
        this.rightArmWear.restore(playerModel.f_103375_);
        this.leftArmWear.restore(playerModel.f_103374_);
        this.rightLegWear.restore(playerModel.f_103377_);
        this.leftLegWear.restore(playerModel.f_103376_);
    }

    private static class ModelStateHolder {
        boolean update;
        boolean showBefore;

        private ModelStateHolder() {
        }

        private void update(ModelPart modelRenderer) {
            this.showBefore = modelRenderer.f_104207_;
            this.update = true;
            modelRenderer.f_104207_ = false;
        }

        private void restore(ModelPart modelRenderer) {
            if (this.update) {
                this.update = false;
                modelRenderer.f_104207_ = this.showBefore;
            }
        }
    }
}

