/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.jetboots.client.overlay;

import com.black_dog20.bml.client.DrawUtil;
import com.black_dog20.bml.client.overlay.configure.ConfigurablePercentageScaledOverlay;
import com.black_dog20.bml.utils.color.Color4i;
import com.black_dog20.jetboots.Config;
import com.black_dog20.jetboots.common.util.EnergyUtil;
import com.black_dog20.jetboots.common.util.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.NamedGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;

public class BatteryIconOverlay
extends ConfigurablePercentageScaledOverlay.Post {
    private static final ResourceLocation BATTERY_FULL = new ResourceLocation("jetboots", "textures/gui/battery_icon_full.png");
    private static final ResourceLocation BATTERY_ABOVE_HALF = new ResourceLocation("jetboots", "textures/gui/battery_icon_above_half.png");
    private static final ResourceLocation BATTERY_HALF = new ResourceLocation("jetboots", "textures/gui/battery_icon_half.png");
    private static final ResourceLocation BATTERY_BELOW_HALF = new ResourceLocation("jetboots", "textures/gui/battery_icon_below_half.png");
    private static final ResourceLocation BATTERY_NEARLY_EMPTY = new ResourceLocation("jetboots", "textures/gui/battery_icon_nearly_empty.png");
    private static final ResourceLocation BATTERY_EMPTY = new ResourceLocation("jetboots", "textures/gui/battery_icon_empty.png");
    private int ticks = 1;
    private boolean flickState = true;

    public void setPercentagePosition(int percentageX, int percentageY) {
        Config.ICON_X_PERCENTAGE.set((Object)percentageX);
        Config.ICON_Y_PERCENTAGE.set((Object)percentageY);
        Config.ICON_X_PERCENTAGE.save();
        Config.ICON_Y_PERCENTAGE.save();
    }

    public int getPercentagePosX() {
        return (Integer)Config.ICON_X_PERCENTAGE.get();
    }

    public int getPercentagePosY() {
        return (Integer)Config.ICON_Y_PERCENTAGE.get();
    }

    public void onRender(GuiGraphics guiGraphics, int scaledwidth, int scaledheight) {
        int xPos = (int)((double)scaledwidth * ((double)this.getPercentagePosX() / 100.0));
        int yPos = (int)((double)scaledheight * ((double)this.getPercentagePosY() / 100.0));
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        guiGraphics.m_280168_().m_85836_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ItemStack jetboots = ModUtils.getJetBoots((Player)player);
        if (!jetboots.m_41619_()) {
            int percentage = EnergyUtil.getBatteryPercentage(jetboots);
            if (BatteryIconOverlay.isBetween(percentage, 80, 100)) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BATTERY_FULL);
                this.ticks = 1;
            } else if (BatteryIconOverlay.isBetween(percentage, 60, 80)) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BATTERY_ABOVE_HALF);
                this.ticks = 1;
            } else if (BatteryIconOverlay.isBetween(percentage, 40, 60)) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BATTERY_HALF);
                this.ticks = 1;
            } else if (BatteryIconOverlay.isBetween(percentage, 20, 40)) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BATTERY_BELOW_HALF);
                this.ticks = 1;
            } else if (BatteryIconOverlay.isBetween(percentage, 10, 20)) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BATTERY_NEARLY_EMPTY);
                this.ticks = 1;
            } else {
                if (this.ticks % 50 == 0) {
                    this.flickState = !this.flickState;
                    this.ticks = 1;
                }
                if (this.flickState) {
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)BATTERY_NEARLY_EMPTY);
                } else {
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)BATTERY_EMPTY);
                }
                ++this.ticks;
            }
            DrawUtil.drawNonStandardTexturedRect((int)xPos, (int)yPos, (int)0, (int)0, (int)18, (int)18, (int)18, (int)18);
        }
        guiGraphics.m_280168_().m_85849_();
    }

    private static boolean isBetween(int x, int lower, int upper) {
        return lower < x && x <= upper;
    }

    public boolean doRender(NamedGuiOverlay overlay) {
        if (!((Boolean)Config.BATTERY_ICON_STATE.get()).booleanValue()) {
            return false;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        boolean playerListShown = minecraft.f_91066_.f_92099_.m_90857_();
        boolean showDebugInfo = minecraft.f_91066_.f_92063_;
        boolean chatOpen = minecraft.f_91080_ instanceof ChatScreen;
        return !showDebugInfo && !playerListShown && !chatOpen && overlay.id().equals((Object)VanillaGuiOverlay.CROSSHAIR.id());
    }

    public boolean doesCancelEvent() {
        return false;
    }

    public int getHeight() {
        return 18;
    }

    public int getWidth() {
        return 18;
    }

    public Color4i getActiveColor() {
        return Color4i.of((int)0, (int)255, (int)0, (int)50);
    }

    public boolean getSate() {
        return (Boolean)Config.BATTERY_ICON_STATE.get();
    }

    public boolean isStateChangeable() {
        return true;
    }

    public void setState(boolean state) {
        Config.BATTERY_ICON_STATE.set((Object)state);
        Config.BATTERY_ICON_STATE.save();
    }

    public Optional<Component> getMessage() {
        return Optional.empty();
    }
}

