/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.jetboots.client.events;

import com.black_dog20.bml.event.ArmorEvent;
import com.black_dog20.jetboots.client.ClientHelper;
import com.black_dog20.jetboots.common.items.ModItems;
import com.black_dog20.jetboots.common.util.EnergyUtil;
import com.black_dog20.jetboots.common.util.ModUtils;
import com.black_dog20.jetboots.common.util.TranslationHelper;
import com.black_dog20.jetboots.common.util.properties.GuardinanHelmetProperties;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="jetboots", value={Dist.CLIENT})
public class ClientHandler {
    private static int tickCounter = 0;

    @SubscribeEvent
    public void onStopTracking(PlayerEvent.StopTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ClientHelper.stop(player);
        }
    }

    @SubscribeEvent
    public static void overlayEvent(RenderGuiOverlayEvent.Pre event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && ModUtils.hasGuardianHelmet((Player)player) && GuardinanHelmetProperties.getMode(ModUtils.getGuardianHelmet((Player)player)) && event.getOverlay().id().equals((Object)VanillaGuiOverlay.AIR_LEVEL.id())) {
            event.setCanceled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onArmorTick(ArmorEvent.Tick event) {
        if (!event.isArmorEqualTo((Item)ModItems.JET_BOOTS.get())) {
            return;
        }
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        if (event.player.m_20148_() != Minecraft.m_91087_().f_91074_.m_20148_()) {
            return;
        }
        if (tickCounter % 240 == 0) {
            ItemStack jetboots = event.armor;
            int percent = EnergyUtil.getBatteryPercentage(jetboots);
            if (percent < 10) {
                Minecraft.m_91087_().f_91065_.m_93063_(TranslationHelper.Translations.POWER_LOW.get(), false);
            }
            tickCounter = 1;
        }
        ++tickCounter;
    }
}

