/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinygates.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModWidget
extends AbstractWidget {
    private HAlignment halignment = HAlignment.LEFT;
    private VAlignment valignment = VAlignment.TOP;
    private float scale = 1.0f;
    private int color;
    private int bgcolor = -1;
    private int textWidth;
    private int textHeight;
    private Component toolTipTextComponent;
    private IPressable pressedAction = null;

    public ModWidget(int x, int y, int width, int height, Component title, int textColor, int bgColor) {
        super(x, y, width, height, title);
        this.color = textColor;
        this.bgcolor = bgColor;
        if (title.getString().length() > 0) {
            this.textWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.m_6035_());
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            this.textHeight = 9;
        }
    }

    public ModWidget(int x, int y, int width, int height, Component title, int textColor) {
        this(x, y, width, height, title, textColor, -1);
    }

    public ModWidget(int x, int y, int width, int height, Component title) {
        this(x, y, width, height, title, -1, -1);
    }

    public ModWidget(int x, int y, int width, int height, int bgColor) {
        this(x, y, width, height, Component.m_130674_((String)""), -1, bgColor);
    }

    public ModWidget(int x, int y, int width, int height, int bgColor, IPressable pressedAction) {
        this(x, y, width, height, Component.m_130674_((String)""), -1, bgColor);
        this.pressedAction = pressedAction;
    }

    public ModWidget setTextHAlignment(HAlignment alignment) {
        this.halignment = alignment;
        return this;
    }

    public ModWidget setTextVAlignment(VAlignment alignment) {
        this.valignment = alignment;
        return this;
    }

    public ModWidget setToolTip(Component textComponent) {
        this.toolTipTextComponent = textComponent;
        return this;
    }

    protected boolean m_93680_(double mouseX, double mouseY) {
        if (this.pressedAction == null || mouseX < (double)this.m_252754_() || mouseX > (double)(this.m_252754_() + this.f_93618_) || mouseY < (double)this.m_252907_() || mouseY > (double)(this.m_252907_() + this.f_93619_)) {
            return false;
        }
        this.pressedAction.onPress(this);
        return true;
    }

    protected void m_168797_(NarrationElementOutput p_259858_) {
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.f_93624_) {
            Font fr = Minecraft.m_91087_().f_91062_;
            int drawX = switch (this.halignment) {
                default -> this.m_252754_();
                case HAlignment.CENTER -> this.m_252754_() + (int)((float)((this.f_93618_ - this.textWidth) / 2) * this.scale);
                case HAlignment.RIGHT -> this.m_252754_() + (int)((float)(this.f_93618_ - this.textWidth) * this.scale);
            };
            switch (this.valignment) {
                default: {
                    int drawY = this.m_252907_();
                    break;
                }
                case MIDDLE: {
                    int drawY = this.m_252907_() + (int)((float)((this.f_93619_ - this.textHeight) / 2) * this.scale);
                    break;
                }
                case BOTTOM: {
                    int drawY = this.m_252907_() + (int)((float)(this.f_93619_ - this.textHeight) * this.scale);
                }
            }
            PoseStack matrixStack = guiGraphics.m_280168_();
            if (this.scale != 1.0f) {
                matrixStack.m_85836_();
                matrixStack.m_85841_(this.scale, this.scale, this.scale);
                matrixStack.m_252880_((float)drawX, (float)this.m_252907_(), 0.0f);
                guiGraphics.m_280648_(fr, this.m_6035_().m_7532_(), drawX, this.m_252907_(), this.color);
                matrixStack.m_85849_();
            } else {
                guiGraphics.m_280648_(fr, this.m_6035_().m_7532_(), drawX, this.m_252907_(), this.color);
            }
            if (this.bgcolor != -1) {
                guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, this.bgcolor);
            }
            if (this.toolTipTextComponent != null && mouseX >= this.m_252754_() && mouseX <= this.m_252754_() + this.f_93618_ && mouseY >= this.m_252907_() && mouseY <= this.m_252907_() + this.f_93619_) {
                this.renderHoverToolTip(guiGraphics, mouseX, mouseY);
            }
        }
    }

    public void renderHoverToolTip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.toolTipTextComponent != null) {
            Font fr = Minecraft.m_91087_().f_91062_;
            int width = fr.m_92852_((FormattedText)this.toolTipTextComponent);
            Objects.requireNonNull(fr);
            int height = 9;
            guiGraphics.m_280509_(mouseX, mouseY + 10, mouseX + width + 4, mouseY + 10 + height + 4, -872415232);
            guiGraphics.m_280509_(mouseX + 1, mouseY + 11, mouseX + width + 3, mouseY + 10 + height + 3, 0x66EEEEEE);
            guiGraphics.m_280648_(fr, this.toolTipTextComponent.m_7532_(), mouseX + 3, mouseY + 13, -65794);
        }
    }

    public static Button buildButton(Integer xPos, Integer yPos, Integer width, Integer height, Component component, Button.OnPress onPress) {
        return Button.m_253074_((Component)component, (Button.OnPress)onPress).m_252794_(xPos.intValue(), yPos.intValue()).m_253046_(width.intValue(), height.intValue()).m_253136_();
    }

    public static enum HAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static enum VAlignment {
        TOP,
        MIDDLE,
        BOTTOM;

    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface IPressable {
        public void onPress(ModWidget var1);
    }
}

