/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinygates.gates;

import com.dannyandson.tinygates.RenderHelper;
import com.dannyandson.tinygates.gates.AbstractGate;
import com.dannyandson.tinyredstone.api.IOverlayBlockInfo;
import com.dannyandson.tinyredstone.blocks.PanelCellNeighbor;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelCellSegment;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PanelTileRenderer;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.Side;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;

public class EdgeDetector
extends AbstractGate {
    private boolean rising = true;
    private boolean input = false;
    private int ticks = 0;

    public void render(PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, float alpha) {
        VertexConsumer builder = buffer.m_6299_((double)alpha == 1.0 ? RenderType.m_110451_() : RenderType.m_110466_());
        TextureAtlasSprite sprite = RenderHelper.getSprite(PanelTileRenderer.TEXTURE);
        TextureAtlasSprite sprite_gate = RenderHelper.getSprite(this.output ? (this.rising ? RenderHelper.TEXTURE_RISING_ON : RenderHelper.TEXTURE_FALLING_ON) : (this.rising ? RenderHelper.TEXTURE_RISING_OFF : RenderHelper.TEXTURE_FALLING_OFF));
        RenderHelper.drawQuarterSlab(poseStack, builder, sprite_gate, sprite, combinedLight, alpha);
    }

    public boolean neighborChanged(PanelCellPos cellPos) {
        PanelCellNeighbor backNeighbor = cellPos.getNeighbor(Side.BACK);
        boolean previousinput = this.input;
        boolean bl = this.input = backNeighbor != null && backNeighbor.getWeakRsOutput() > 0;
        if (this.rising && !previousinput && this.input || !this.rising && previousinput && !this.input) {
            this.output = true;
            this.ticks = 2;
            return true;
        }
        return false;
    }

    public boolean tick(PanelCellPos cellPos) {
        if (this.output) {
            if (this.ticks <= 0) {
                this.output = false;
                return true;
            }
            --this.ticks;
        }
        return false;
    }

    public boolean hasActivation() {
        return true;
    }

    public boolean onBlockActivated(PanelCellPos cellPos, PanelCellSegment segmentClicked, Player player) {
        this.rising = !this.rising;
        return false;
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag compoundTag = super.writeNBT();
        compoundTag.m_128379_("input", this.input);
        compoundTag.m_128379_("rising", this.rising);
        compoundTag.m_128405_("ticks", this.ticks);
        return compoundTag;
    }

    @Override
    public void readNBT(CompoundTag compoundTag) {
        super.readNBT(compoundTag);
        this.input = compoundTag.m_128471_("input");
        this.rising = compoundTag.m_128471_("rising");
        this.ticks = compoundTag.m_128451_("ticks");
    }

    @Override
    public void addInfo(IOverlayBlockInfo overlayBlockInfo, PanelTile panelTile, PosInPanelCell posInPanelCell) {
        overlayBlockInfo.addText("Detecting", (this.rising ? "Rising" : "Falling") + " edge");
    }
}

