/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinygates.gates;

import com.dannyandson.tinygates.RenderHelper;
import com.dannyandson.tinygates.gates.AbstractGate;
import com.dannyandson.tinygates.gui.TinyClockGUI;
import com.dannyandson.tinygates.network.ModNetworkHandler;
import com.dannyandson.tinyredstone.api.IOverlayBlockInfo;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.blocks.PanelCellNeighbor;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelCellSegment;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PanelTileRenderer;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.network.PanelCellSync;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;

public class Clock
extends AbstractGate {
    private int ticks = 20;
    private int tick = 0;
    private boolean input = false;

    public void render(PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, float alpha) {
        VertexConsumer builder = buffer.m_6299_((double)alpha == 1.0 ? RenderType.m_110451_() : RenderType.m_110466_());
        TextureAtlasSprite sprite = RenderHelper.getSprite(PanelTileRenderer.TEXTURE);
        TextureAtlasSprite sprite_gate = RenderHelper.getSprite(this.output ? RenderHelper.TEXTURES_CLOCK[RenderHelper.TEXTURES_CLOCK.length - 1] : RenderHelper.TEXTURES_CLOCK[Math.min(Math.floorDiv(this.tick * (RenderHelper.TEXTURES_CLOCK.length - 1), this.ticks), RenderHelper.TEXTURES_CLOCK.length - 1)]);
        RenderHelper.drawQuarterSlab(poseStack, builder, sprite_gate, sprite, combinedLight, alpha);
    }

    public boolean neighborChanged(PanelCellPos cellPos) {
        PanelCellNeighbor backNeighbor = cellPos.getNeighbor(Side.BACK);
        this.input = backNeighbor != null && backNeighbor.getWeakRsOutput() > 0;
        return false;
    }

    public boolean tick(PanelCellPos cellPos) {
        if (!this.input) {
            ++this.tick;
            if (this.tick >= this.ticks) {
                this.output = true;
                this.tick = 0;
                return true;
            }
            if (this.output && this.tick > 1) {
                this.output = false;
                return true;
            }
            this.sendToClient(cellPos);
        }
        return false;
    }

    public boolean hasActivation() {
        return true;
    }

    public boolean onBlockActivated(PanelCellPos cellPos, PanelCellSegment segmentClicked, Player player) {
        PanelTile panelTile = cellPos.getPanelTile();
        if (panelTile.m_58904_().f_46443_) {
            TinyClockGUI.open(panelTile, cellPos.getIndex(), this);
        }
        return false;
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag compoundTag = super.writeNBT();
        compoundTag.m_128405_("ticks", this.ticks);
        compoundTag.m_128405_("tick", this.tick);
        compoundTag.m_128379_("input", this.input);
        return compoundTag;
    }

    @Override
    public void readNBT(CompoundTag compoundTag) {
        super.readNBT(compoundTag);
        this.ticks = compoundTag.m_128451_("ticks");
        this.tick = compoundTag.m_128451_("tick");
        this.input = compoundTag.m_128471_("input");
    }

    public Integer getTicks() {
        return this.ticks;
    }

    public void setTicks(Integer ticks) {
        if (ticks < this.tick) {
            this.tick = 0;
        }
        this.ticks = ticks < 2 ? 2 : (ticks > 200 ? 200 : ticks);
    }

    @Override
    public void addInfo(IOverlayBlockInfo overlayBlockInfo, PanelTile panelTile, PosInPanelCell posInPanelCell) {
        overlayBlockInfo.addText("Rate", this.ticks / 2 + " ticks");
        if (this.input) {
            overlayBlockInfo.addInfo("Locked");
        }
    }

    public void sendToClient(PanelCellPos cellPos) {
        PanelTile panelTile = cellPos.getPanelTile();
        BlockPos pos = panelTile.m_58899_();
        for (Player player : panelTile.m_58904_().m_6907_()) {
            if (!(player instanceof ServerPlayer) || !(player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) < 64.0)) continue;
            ModNetworkHandler.getINSTANCE().sendTo((Object)new PanelCellSync(pos, cellPos.getIndex(), this.writeNBT()), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static void clockTickSync(BlockEntity blockEntity, int cellIndex, int ticks) {
        PanelTile panelTile;
        PanelCellPos cellPos;
        IPanelCell cell;
        if (blockEntity instanceof PanelTile && (cell = (cellPos = PanelCellPos.fromIndex((PanelTile)(panelTile = (PanelTile)blockEntity), (Integer)cellIndex)).getIPanelCell()) instanceof Clock) {
            Clock clockCell = (Clock)cell;
            clockCell.setTicks(ticks);
            panelTile.flagSync();
        }
    }
}

