/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinygates.blocks;

import com.dannyandson.tinygates.blocks.AbstractGateBlockEntity;
import com.dannyandson.tinygates.blocks.Side;
import com.dannyandson.tinygates.setup.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGateBlock
extends BaseEntityBlock {
    protected abstract AbstractGateBlockEntity newAbstractGateBlockEntity(BlockPos var1, BlockState var2);

    public abstract boolean canConnectRedstone(Side var1);

    protected AbstractGateBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_60978_(0.2f));
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return this.newAbstractGateBlockEntity(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61372_});
        builder.m_61104_(new Property[]{Registration.GATE_DIRECTION});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_43719_().m_122424_();
        Direction hfacing = null;
        if (facing == Direction.DOWN || facing == Direction.UP) {
            hfacing = context.m_8125_();
        } else {
            for (Direction dir : context.m_6232_()) {
                if (dir == facing || dir == facing.m_122424_()) continue;
                hfacing = dir.m_122424_();
            }
        }
        if (hfacing == null) {
            hfacing = Direction.UP;
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)facing)).m_61124_((Property)Registration.GATE_DIRECTION, (Comparable)hfacing);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        if (direction != null) {
            return this.canConnectRedstone(this.getSideFromDirection(direction.m_122424_(), state));
        }
        return true;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighbor, boolean p_60514_) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AbstractGateBlockEntity) {
            AbstractGateBlockEntity gateEntity = (AbstractGateBlockEntity)blockEntity;
            if (gateEntity.onNeighborChange(neighbor)) {
                gateEntity.outputChange();
            }
        } else {
            super.onNeighborChange(state, (LevelReader)level, pos, neighbor);
        }
    }

    public void m_6807_(BlockState p_60566_, Level level, BlockPos pos, BlockState p_60569_, boolean p_60570_) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AbstractGateBlockEntity) {
            AbstractGateBlockEntity gateEntity = (AbstractGateBlockEntity)blockEntity;
            if (gateEntity.onNeighborChange(null)) {
                gateEntity.outputChange();
            }
        } else {
            super.m_6807_(p_60566_, level, pos, p_60569_, p_60570_);
        }
    }

    protected void m_142387_(Level p_152422_, Player p_152423_, BlockPos p_152424_, BlockState p_152425_) {
        super.m_142387_(p_152422_, p_152423_, p_152424_, Blocks.f_50075_.m_49966_());
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!player.m_7500_()) {
            ItemStack itemStack = new ItemStack((ItemLike)this);
            ItemEntity itementity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemStack);
            itementity.m_32060_();
            level.m_7967_((Entity)itementity);
        }
        super.m_5707_(level, pos, state, player);
    }

    public int m_6376_(@NotNull BlockState blockState, BlockGetter blockGetter, @NotNull BlockPos pos, @NotNull Direction direction) {
        BlockEntity blockEntity = blockGetter.m_7702_(pos);
        if (blockEntity instanceof AbstractGateBlockEntity) {
            AbstractGateBlockEntity gateEntity = (AbstractGateBlockEntity)blockEntity;
            return gateEntity.getDirectSignal(this.getSideFromDirection(direction.m_122424_(), blockState));
        }
        return super.m_6376_(blockState, blockGetter, pos, direction);
    }

    public int m_6378_(@NotNull BlockState blockState, BlockGetter blockGetter, @NotNull BlockPos pos, @NotNull Direction direction) {
        BlockEntity blockEntity = blockGetter.m_7702_(pos);
        if (blockEntity instanceof AbstractGateBlockEntity) {
            AbstractGateBlockEntity gateEntity = (AbstractGateBlockEntity)blockEntity;
            return gateEntity.getSignal(this.getSideFromDirection(direction.m_122424_(), blockState));
        }
        return super.m_6378_(blockState, blockGetter, pos, direction);
    }

    public boolean shouldCheckWeakPower(BlockState state, SignalGetter world, BlockPos pos, Direction directionFromNeighborToThis) {
        return false;
    }

    public boolean m_7899_(@NotNull BlockState p_60571_) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        switch (facing) {
            case NORTH: {
                return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
            }
            case EAST: {
                return Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            }
            case SOUTH: {
                return Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
            }
            case WEST: {
                return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
            }
            case UP: {
                return Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            }
        }
        return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    }

    public Side getSideFromDirection(Direction direction, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        Direction hfacing = (Direction)state.m_61143_((Property)Registration.GATE_DIRECTION);
        if (direction == hfacing) {
            return Side.FRONT;
        }
        if (direction == hfacing.m_122424_()) {
            return Side.BACK;
        }
        if (direction == facing) {
            return Side.BOTTOM;
        }
        if (direction == facing.m_122424_()) {
            return Side.TOP;
        }
        switch (facing) {
            case DOWN: {
                if (direction == hfacing.m_122427_()) {
                    return Side.RIGHT;
                }
                return Side.LEFT;
            }
            case UP: {
                if (direction == hfacing.m_122427_()) {
                    return Side.LEFT;
                }
                return Side.RIGHT;
            }
            case NORTH: {
                if (direction == hfacing.m_175362_(Direction.Axis.Z)) {
                    return Side.LEFT;
                }
                return Side.RIGHT;
            }
            case SOUTH: {
                if (direction == hfacing.m_175362_(Direction.Axis.Z)) {
                    return Side.RIGHT;
                }
                return Side.LEFT;
            }
            case EAST: {
                if (direction == hfacing.m_175364_(Direction.Axis.X)) {
                    return Side.LEFT;
                }
                return Side.RIGHT;
            }
            case WEST: {
                if (direction == hfacing.m_175364_(Direction.Axis.X)) {
                    return Side.RIGHT;
                }
                return Side.LEFT;
            }
        }
        return Side.TOP;
    }
}

