/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.core.camera;

import com.pedrorok.hypertube.config.ClientConfig;
import com.pedrorok.hypertube.core.camera.DetachedPlayerDirController;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DetachedCameraController {
    private static DetachedCameraController INSTANCE;
    private float yaw = 0.0f;
    private float pitch = 0.0f;
    private Vec3 currentPos = Vec3.f_82478_;
    private Vec3 targetPos = Vec3.f_82478_;
    private float targetYaw = 0.0f;
    private float targetPitch = 0.0f;
    private static final double SMOOTHING = 0.1;
    private static final double SMOOTHING_ROTATION = 0.1;
    private float lastMouseMov = 0.0f;
    private boolean detached = false;
    private float cameraHorizontalCompensation = 0.0f;
    private Direction checkDirection = null;
    private static double lastMouseX;
    private static double lastMouseY;

    public static DetachedCameraController get() {
        if (INSTANCE == null) {
            INSTANCE = new DetachedCameraController();
        }
        return INSTANCE;
    }

    private DetachedCameraController() {
    }

    public void startCamera(Entity renderViewEntity) {
        Vec3 cameraPos;
        this.currentPos = cameraPos = this.getRelativeCameraPos(renderViewEntity);
        this.targetPos = cameraPos;
        this.lastMouseMov = 0.0f;
        this.yaw = this.targetYaw = Mth.m_14177_((float)renderViewEntity.m_146908_());
        this.targetPitch = 30.0f;
        this.pitch = 30.0f;
    }

    public void updateCameraRotation(float deltaYaw, float deltaPitch, boolean isCamera) {
        this.targetYaw = Mth.m_14177_((float)(this.targetYaw + deltaYaw));
        this.targetPitch = Mth.m_14036_((float)(this.targetPitch + deltaPitch), (float)-90.0f, (float)90.0f);
        if (this.lastMouseMov != 0.0f) {
            this.lastMouseMov = Math.max(0.0f, this.lastMouseMov - 0.015f);
        }
        if (isCamera && deltaYaw != 0.0f) {
            this.lastMouseMov = 2.0f;
        }
    }

    private float getCameraYaw(Vec3 entityPos, Vec3 cameraPos) {
        Vec3 cameraToPlayerNormal = cameraPos.m_82546_(entityPos).m_82542_(1.0, 0.0, 1.0).m_82541_();
        float yaw = (float)Math.toDegrees(Math.atan2(cameraToPlayerNormal.f_82481_, cameraToPlayerNormal.f_82479_)) + 90.0f;
        yaw = Mth.m_14177_((float)(yaw + this.cameraHorizontalCompensation));
        return ((yaw - this.yaw + 540.0f) % 360.0f - 180.0f) * (1.0f - Math.min(this.lastMouseMov, 1.0f));
    }

    private float getCameraPitch(float entityPitch) {
        float compensatedPitch = entityPitch < 50.0f ? -entityPitch : -entityPitch / 2.0f;
        return ((30.0f - (this.pitch + compensatedPitch) + 540.0f) % 360.0f - 180.0f) * (1.0f - Math.min(this.lastMouseMov, 1.0f));
    }

    private Vec3 getRelativeCameraPos(Entity renderViewEntity) {
        Vec3 dir = DetachedPlayerDirController.get().getDirection();
        return renderViewEntity.m_20182_().m_82546_(dir.m_82542_(8.0, 8.0, 8.0)).m_82520_(0.0, 3.0, 0.0);
    }

    public void tickCamera(Entity renderViewEntity) {
        Vec3 entityPos = renderViewEntity.m_20182_();
        Vec3 relativeCameraPos = this.getRelativeCameraPos(renderViewEntity);
        this.updateCameraRotation(this.getCameraYaw(entityPos, relativeCameraPos) * 0.1f, this.getCameraPitch(renderViewEntity.m_146909_()) * 0.1f, false);
        this.updateTargetPosition(relativeCameraPos);
        this.tickCameraPosRot();
    }

    public void updateTargetPosition(Vec3 pos) {
        this.targetPos = pos;
    }

    public void tickCameraPosRot() {
        this.currentPos = this.currentPos.m_165921_(this.targetPos, 0.1);
        this.yaw = this.lerpAngle(this.yaw, this.targetYaw, 0.1f);
        this.pitch = (float)Mth.m_14139_((double)0.1, (double)this.pitch, (double)this.targetPitch);
    }

    private float lerpAngle(float from, float to, float t) {
        float delta = Mth.m_14177_((float)(to - from));
        return from + delta * t;
    }

    public static void cameraTick() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.m_92176_().m_90612_() && ((Boolean)ClientConfig.get().ALLOW_FPV_INSIDE_TUBE.get()).booleanValue() || mc.m_91104_() || !mc.m_91302_() || mc.f_91080_ != null) {
            return;
        }
        MouseHandler mouse = mc.f_91067_;
        double dx = mouse.m_91589_() - lastMouseX;
        double dy = mouse.m_91594_() - lastMouseY;
        double sensitivity = (Double)mc.f_91066_.m_231964_().m_231551_();
        double factor = sensitivity * 0.3 + 0.1;
        factor = factor * factor * factor * 8.0;
        DetachedCameraController.get().updateCameraRotation((float)(dx * factor), (float)(dy * factor), true);
        lastMouseX = mc.f_91067_.m_91589_();
        lastMouseY = mc.f_91067_.m_91594_();
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public Vec3 getCurrentPos() {
        return this.currentPos;
    }

    public float getTargetYaw() {
        return this.targetYaw;
    }

    public float getTargetPitch() {
        return this.targetPitch;
    }

    public boolean isDetached() {
        return this.detached;
    }

    public void setDetached(boolean detached) {
        this.detached = detached;
    }

    public float getCameraHorizontalCompensation() {
        return this.cameraHorizontalCompensation;
    }

    public void setCameraHorizontalCompensation(float cameraHorizontalCompensation) {
        this.cameraHorizontalCompensation = cameraHorizontalCompensation;
    }

    public Direction getCheckDirection() {
        return this.checkDirection;
    }

    public void setCheckDirection(Direction checkDirection) {
        this.checkDirection = checkDirection;
    }

    static {
        lastMouseX = 0.0;
        lastMouseY = 0.0;
    }
}

