/*
 * Decompiled with CFR 0.152.
 */
package chiefarug.mods.systeams.recipe;

import chiefarug.mods.systeams.SysteamsConfig;
import chiefarug.mods.systeams.SysteamsRegistry;
import cofh.core.util.helpers.FluidHelper;
import cofh.thermal.lib.util.managers.SingleFluidFuelManager;
import cofh.thermal.lib.util.recipes.ThermalFuel;
import cofh.thermal.lib.util.recipes.internal.BaseDynamoFuel;
import cofh.thermal.lib.util.recipes.internal.IDynamoFuel;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;

public class SteamFuelManager
extends SingleFluidFuelManager {
    public static final int MIN_ENERGY = 1000;
    private static final SteamFuelManager INSTANCE = new SteamFuelManager();
    protected static final int DEFAULT_ENERGY = 100000;

    public static SteamFuelManager instance() {
        return INSTANCE;
    }

    private SteamFuelManager() {
        super(100000);
    }

    public int getEnergy(FluidStack stack) {
        IDynamoFuel fuel = this.getFuel(stack);
        return fuel != null ? fuel.getEnergy() : 0;
    }

    public void refresh(RecipeManager recipeManager) {
        this.clear();
        Map recipes = recipeManager.m_44054_((RecipeType)SysteamsRegistry.Recipes.STEAM_TYPE.get());
        for (Map.Entry entry : recipes.entrySet()) {
            this.addFuel((ThermalFuel)entry.getValue());
        }
    }

    public IDynamoFuel addFuel(int energy, List<ItemStack> inputItems, List<FluidStack> inputFluids) {
        if (inputFluids.isEmpty() || energy <= 0) {
            return null;
        }
        if (energy < 1000 || energy > 200000000) {
            return null;
        }
        FluidStack input = inputFluids.get(0);
        if (input.isEmpty()) {
            return null;
        }
        int amount = input.getAmount();
        if (amount != 100) {
            if (amount != 1000) {
                long normEnergy = (long)energy * 1000L / (long)amount;
                input.setAmount(100);
                energy = (int)normEnergy;
            }
            energy /= 10;
        }
        energy = (int)((float)energy * this.getDefaultScale());
        BaseDynamoFuel fuel = new BaseDynamoFuel(energy, inputItems, inputFluids);
        this.fuelMap.put(FluidHelper.fluidHashcode((FluidStack)input), fuel);
        return fuel;
    }

    public int getBasePower() {
        return (Integer)SysteamsConfig.STEAM_DYNAMO_POWER.get();
    }
}

