/*
 * Decompiled with CFR 0.152.
 */
package chiefarug.mods.systeams.recipe;

import chiefarug.mods.systeams.SysteamsRegistry;
import chiefarug.mods.systeams.recipe.BoilingRecipe;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.common.fluid.FluidIngredient;
import cofh.thermal.lib.util.managers.AbstractManager;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;

public class BoilingRecipeManager
extends AbstractManager {
    private static final int DEFAULT_ENERGY = 1000;
    private static final BoilingRecipeManager INSTANCE = new BoilingRecipeManager();
    private Map<HashFluid, BoiledFluid> recipes = new Object2ObjectOpenHashMap();

    public BoilingRecipeManager() {
        super(1000);
    }

    public static BoilingRecipeManager instance() {
        return INSTANCE;
    }

    public boolean canBoil(FluidStack in) {
        return this.boil(in) != null;
    }

    @Nullable
    public BoiledFluid boil(FluidStack in) {
        return this.recipes.get(new HashFluid(in));
    }

    public void addRecipe(BoilingRecipe recipe) {
        FluidStack out = (FluidStack)recipe.getOutputFluids().get(0);
        for (FluidStack in : ((FluidIngredient)recipe.getInputFluids().get(0)).getFluids()) {
            this.recipes.put(new HashFluid(in), new BoiledFluid(in.getAmount(), out));
        }
    }

    public void refresh(RecipeManager recipeManager) {
        Map recipes = recipeManager.m_44054_((RecipeType)SysteamsRegistry.Recipes.BOILING_TYPE.get());
        this.recipes = new Object2ObjectOpenHashMap(recipes.size());
        for (Map.Entry entry : recipes.entrySet()) {
            this.addRecipe((BoilingRecipe)((Object)entry.getValue()));
        }
    }

    public record BoiledFluid(double inToOutRatio, FluidStack fluidOut) {
        public BoiledFluid(int inAmount, FluidStack fluidOut) {
            this((double)inAmount / (double)fluidOut.getAmount(), fluidOut);
        }

        public int getInPerTick(int outPerTick) {
            return (int)Math.floor(this.inToOutRatio * (double)outPerTick);
        }
    }

    record HashFluid(FluidStack fluid) {
        @Override
        public int hashCode() {
            return FluidHelper.fluidHashcode((FluidStack)this.fluid);
        }
    }
}

