/*
 * Decompiled with CFR 0.152.
 */
package chiefarug.mods.systeams.client.screens;

import chiefarug.mods.systeams.block_entities.BoilerBlockEntityBase;
import chiefarug.mods.systeams.containers.BoilerMenuBase;
import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.ElementBase;
import cofh.core.client.gui.element.ElementFluidStorage;
import cofh.core.client.gui.element.ElementItem;
import cofh.core.client.gui.element.panel.PanelBase;
import cofh.core.client.gui.element.panel.ResourcePanel;
import cofh.core.util.helpers.GuiHelper;
import cofh.lib.api.block.entity.ITileCallback;
import cofh.lib.common.fluid.FluidStorageCoFH;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.client.gui.ThermalGuiHelper;
import cofh.thermal.lib.client.gui.AugmentableTileScreen;
import cofh.thermal.lib.common.block.entity.AugmentableBlockEntity;
import java.util.List;
import java.util.function.DoubleSupplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class BoilerScreenBase<T extends BoilerMenuBase<?>>
extends AugmentableTileScreen<T> {
    protected BoilerBlockEntityBase blockEntity;

    public BoilerScreenBase(String id, T container, Inventory inv, BoilerBlockEntityBase blockEntity, Component titleIn) {
        super(container, inv, (AugmentableBlockEntity)blockEntity, titleIn);
        this.blockEntity = blockEntity;
        this.info = GuiHelper.appendLine((String)GuiHelper.generatePanelInfo((String)("info.systeams." + id + "_boiler")), (String)"info.systeams.boiler.throttle");
    }

    protected int getFlameXOffset() {
        return 0;
    }

    public void m_7856_() {
        super.m_7856_();
        this.addPanel((PanelBase)new ResourcePanel((IGuiAccess)this){
            private final DoubleSupplier maxAmt;
            {
                this.maxAmt = BoilerScreenBase.this.blockEntity::currentWaterConsumption;
            }

            protected void drawForeground(GuiGraphics pGuiGraphics) {
                super.drawForeground(pGuiGraphics);
                if (this.fullyOpen && this.maxAmt.getAsDouble() >= 0.0) {
                    pGuiGraphics.m_280056_(this.fontRenderer(), StringHelper.localize((String)"info.systeams.water_cons") + ":", this.sideOffset() + 6, 42, this.subheaderColor, true);
                    pGuiGraphics.m_280056_(this.fontRenderer(), String.format("%.2f", this.maxAmt.getAsDouble()) + " " + StringHelper.localize((String)"info.cofh.unit_mb_t"), this.sideOffset() + 14, 54, this.textColor, false);
                }
            }
        }.setResource(GuiHelper.ICON_STEAM, "info.systeams.steam", true).setEfficiency(() -> ((AugmentableBlockEntity)this.tile).getEfficiency()).setCurrent(() -> ((AugmentableBlockEntity)this.tile).getCurSpeed(), "info.systeams.steam_prod", "info.cofh.unit_mb_t"));
        this.addElement((ElementBase)ThermalGuiHelper.createDefaultDuration((IGuiAccess)this, (int)(80 + this.getFlameXOffset()), (int)35, (ResourceLocation)GuiHelper.SCALE_FLAME, (AugmentableBlockEntity)this.tile));
        this.addElement((ElementBase)GuiHelper.setClearable((ElementFluidStorage)GuiHelper.createMediumFluidStorage((IGuiAccess)this, (int)10, (int)22, (FluidStorageCoFH)this.blockEntity.waterTank), (ITileCallback)this.blockEntity, (int)0));
        this.addElement((ElementBase)GuiHelper.setClearable((ElementFluidStorage)GuiHelper.createMediumFluidStorage((IGuiAccess)this, (int)128, (int)22, (FluidStorageCoFH)this.blockEntity.steamTank), (ITileCallback)this.blockEntity, (int)1));
        this.addElement(new ElementItem((IGuiAccess)this, 154, 4).setItem(() -> ((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("mekanism", "basic_pressurized_tube"))).m_7968_()).setTooltipFactory((element, mouseX, mouseY) -> List.of(Component.m_237115_((String)"info.systeams.mekanism_gas_output.1"), Component.m_237115_((String)"info.systeams.mekanism_gas_output.2"))).setVisible(() -> this.blockEntity.gasMode).setSize(16, 16));
    }
}

