/*
 * Decompiled with CFR 0.152.
 */
package chiefarug.mods.systeams.block_entities;

import chiefarug.mods.systeams.block_entities.BoilerBlockEntityBase;
import cofh.core.client.renderer.model.ModelUtils;
import cofh.core.common.network.packet.client.TileStatePacket;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.api.StorageGroup;
import cofh.lib.api.block.entity.IPacketHandlerTile;
import cofh.lib.api.fluid.IFluidStackHolder;
import cofh.lib.common.fluid.FluidStorageCoFH;
import cofh.thermal.core.common.config.ThermalCoreConfig;
import cofh.thermal.lib.util.managers.SingleFluidFuelManager;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public abstract class FluidBoilerBlockEntityBase
extends BoilerBlockEntityBase {
    protected FluidStorageCoFH fuelTank = new FluidStorageCoFH(4000, fluid -> this.filter.valid(fluid) && this.getFuelManager().validFuel(fluid));

    public FluidBoilerBlockEntityBase(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.tankInv.addTank(this.fuelTank, StorageGroup.INPUT);
        this.renderFluid = new FluidStack((Fluid)Fluids.f_76193_, 1000);
        this.addAugmentSlots(ThermalCoreConfig.dynamoAugments);
    }

    protected abstract SingleFluidFuelManager getFuelManager();

    @Override
    public List<? extends IFluidStackHolder> inputTanks() {
        return List.of(this.getFuelTank());
    }

    @Override
    protected void processStart() {
        if (this.cacheRenderFluid()) {
            TileStatePacket.sendToClient((IPacketHandlerTile)this);
        }
        super.processStart();
    }

    @Override
    protected int consumeFuel() {
        int energy = this.getFuelEnergy();
        this.fuelTank.drain(100, IFluidHandler.FluidAction.EXECUTE);
        return energy;
    }

    public FluidStorageCoFH getFuelTank() {
        return this.fuelTank;
    }

    protected boolean cacheRenderFluid() {
        FluidStack prevFluid = this.renderFluid;
        this.renderFluid = new FluidStack(this.fuelTank.getFluidStack(), 1000);
        return !FluidHelper.fluidsEqual((FluidStack)this.renderFluid, (FluidStack)prevFluid);
    }

    public void handleStatePacket(FriendlyByteBuf buffer) {
        super.handleStatePacket(buffer);
        this.requestModelDataUpdate();
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(ModelUtils.FLUID, (Object)this.renderFluid).build();
    }
}

