/*
 * Decompiled with CFR 0.152.
 */
package chiefarug.mods.systeams;

import chiefarug.mods.systeams.Boiler;
import chiefarug.mods.systeams.ConversionKitItem;
import chiefarug.mods.systeams.Systeams;
import chiefarug.mods.systeams.block_entities.BoilerBlockEntityBase;
import chiefarug.mods.systeams.block_entities.CompressionBoilerBlockEntity;
import chiefarug.mods.systeams.block_entities.DisenchantmentBoilerBlockEntity;
import chiefarug.mods.systeams.block_entities.GourmandBoilerBlockEntity;
import chiefarug.mods.systeams.block_entities.LapidaryBoilerBlockEntity;
import chiefarug.mods.systeams.block_entities.MagmaticBoilerBlockEntity;
import chiefarug.mods.systeams.block_entities.NumismaticBoilerBlockEntity;
import chiefarug.mods.systeams.block_entities.SteamDynamoBlockEntity;
import chiefarug.mods.systeams.block_entities.StirlingBoilerBlockEntity;
import chiefarug.mods.systeams.client.screens.CompressionBoilerScreen;
import chiefarug.mods.systeams.client.screens.DisenchantmentBoilerScreen;
import chiefarug.mods.systeams.client.screens.GourmandBoilerScreen;
import chiefarug.mods.systeams.client.screens.LapidaryBoilerScreen;
import chiefarug.mods.systeams.client.screens.MagmaticBoilerScreen;
import chiefarug.mods.systeams.client.screens.NumismaticBoilerScreen;
import chiefarug.mods.systeams.client.screens.SteamDynamoScreen;
import chiefarug.mods.systeams.client.screens.StirlingBoilerScreen;
import chiefarug.mods.systeams.compat.pneumaticcraft.SysteamsPNCRCompat;
import chiefarug.mods.systeams.compat.thermal_extra.SysteamsThermalExtraCompat;
import chiefarug.mods.systeams.containers.CompressionBoilerMenu;
import chiefarug.mods.systeams.containers.DisenchantmentBoilerMenu;
import chiefarug.mods.systeams.containers.GourmandBoilerMenu;
import chiefarug.mods.systeams.containers.LapidaryBoilerMenu;
import chiefarug.mods.systeams.containers.MagmaticBoilerMenu;
import chiefarug.mods.systeams.containers.NumismaticBoilerMenu;
import chiefarug.mods.systeams.containers.SteamDynamoMenu;
import chiefarug.mods.systeams.containers.StirlingBoilerMenu;
import chiefarug.mods.systeams.fluid.PlasmaFluid;
import chiefarug.mods.systeams.fluid.SteamFluid;
import chiefarug.mods.systeams.recipe.BoilingRecipe;
import chiefarug.mods.systeams.recipe.BoilingRecipeManager;
import chiefarug.mods.systeams.recipe.SteamFuel;
import chiefarug.mods.systeams.recipe.SteamFuelManager;
import chiefarug.mods.systeams.recipe.UpgradeShapelessRecipe;
import cofh.lib.util.DeferredRegisterCoFH;
import cofh.lib.util.constants.BlockStatePropertiesCoFH;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.recipes.SerializableRecipeType;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.common.config.ThermalCoreConfig;
import cofh.thermal.lib.common.block.DynamoBlock;
import cofh.thermal.lib.common.item.BlockItemAugmentable;
import cofh.thermal.lib.util.ThermalAugmentRules;
import cofh.thermal.lib.util.ThermalRecipeManagers;
import cofh.thermal.lib.util.managers.IManager;
import cofh.thermal.lib.util.recipes.DynamoFuelSerializer;
import cofh.thermal.lib.util.recipes.MachineRecipeSerializer;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;

public class SysteamsRegistry {
    public static final DeferredRegisterCoFH<CreativeModeTab> TAB_REGISTRY = DeferredRegisterCoFH.create((ResourceKey)Registries.f_279569_, (String)"systeams");
    public static final RegistryObject<CreativeModeTab> TAB = TAB_REGISTRY.register("systeams", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.systeams")).m_257737_(() -> new ItemStack((ItemLike)Items.BOILER_PIPE.get())).m_257501_((p, out) -> {
        out.m_246326_((ItemLike)Items.BOILER_PIPE.get());
        out.m_246326_((ItemLike)Items.STEAM_DYNAMO.get());
        out.m_246326_(Boilers.COMPRESSION);
        out.m_246326_(Boilers.GOURMAND);
        out.m_246326_(Boilers.LAPIDARY);
        out.m_246326_(Boilers.MAGMATIC);
        out.m_246326_(Boilers.STIRLING);
        out.m_246326_(Boilers.NUMISMATIC);
        out.m_246326_(Boilers.DISENCHANTMENT);
        ModList mods = ModList.get();
        if (mods.isLoaded("pneumaticcraft")) {
            SysteamsPNCRCompat.fillCreativeTab(out);
        }
        if (mods.isLoaded("thermal_extra")) {
            SysteamsThermalExtraCompat.fillCreativeTab(out);
        }
        out.m_246326_((ItemLike)Fluids.STEAM.getStill().m_6859_());
        out.m_246326_((ItemLike)Fluids.STEAM_2.getStill().m_6859_());
        out.m_246326_((ItemLike)Fluids.STEAM_3.getStill().m_6859_());
        out.m_246326_((ItemLike)Fluids.STEAM_4.getStill().m_6859_());
        out.m_246326_((ItemLike)Fluids.STEAM_5.getStill().m_6859_());
    }).m_257652_());
    public static final Item.Properties I_PROPERTIES = new Item.Properties();
    public static final BlockBehaviour.Properties B_PROPERTIES = BlockBehaviour.Properties.m_60926_((BlockBehaviour)net.minecraft.world.level.block.Blocks.f_50721_).m_60978_(2.0f).m_60953_(BlockHelper.lightValue((BooleanProperty)BlockStatePropertiesCoFH.ACTIVE, (int)14));
    public static final DeferredRegisterCoFH<Fluid> FLUID_REGISTRY = DeferredRegisterCoFH.create((ResourceKey)ForgeRegistries.Keys.FLUIDS, (String)"systeams");
    public static final DeferredRegisterCoFH<FluidType> FLUID_TYPE_REGISTRY = DeferredRegisterCoFH.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"systeams");
    public static final DeferredRegisterCoFH<BlockEntityType<?>> BLOCK_ENTITY_REGISTRY = DeferredRegisterCoFH.create((ResourceKey)ForgeRegistries.Keys.BLOCK_ENTITY_TYPES, (String)"systeams");
    public static final DeferredRegisterCoFH<Block> BLOCK_REGISTRY = DeferredRegisterCoFH.create((ResourceKey)ForgeRegistries.Keys.BLOCKS, (String)"systeams");
    public static final DeferredRegisterCoFH<Item> ITEM_REGISTRY = DeferredRegisterCoFH.create((ResourceKey)ForgeRegistries.Keys.ITEMS, (String)"systeams");
    public static final DeferredRegisterCoFH<SoundEvent> SOUND_REGISTRY = DeferredRegisterCoFH.create((ResourceKey)ForgeRegistries.Keys.SOUND_EVENTS, (String)"systeams");
    public static final DeferredRegisterCoFH<MenuType<?>> MENU_REGISTRY = DeferredRegisterCoFH.create((ResourceKey)ForgeRegistries.Keys.MENU_TYPES, (String)"systeams");
    public static final DeferredRegisterCoFH<RecipeSerializer<?>> RECIPE_SERIALIZER_REGISTRY = DeferredRegisterCoFH.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"systeams");
    public static final DeferredRegisterCoFH<RecipeType<?>> RECIPE_TYPE_REGISTRY = DeferredRegisterCoFH.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)"systeams");
    public static final String STEAM_ID = "steam";
    public static final String STEAM_DYNAMO_ID = "steam_dynamo";
    public static final String STIRLING_BOILER_ID = "stirling_boiler";
    public static final String MAGMATIC_BOILER_ID = "magmatic_boiler";
    public static final String COMPRESSION_BOILER_ID = "compression_boiler";
    public static final String NUMISMATIC_BOILER_ID = "numismatic_boiler";
    public static final String LAPIDARY_BOILER_ID = "lapidary_boiler";
    public static final String DISENCHANTMENT_BOILER_ID = "disenchantment_boiler";
    public static final String GOURMAND_BOILER_ID = "gourmand_boiler";
    public static final String UPGRADE_RECIPE_ID = "upgrade_shapeless";
    public static final String BOILING_ID = "boiling";

    public static void init(IEventBus bus) {
        Fluids.init();
        Blocks.init();
        Items.init();
        BlockEntities.init();
        Menus.init();
        Recipes.init();
        Boilers.init();
        TAB_REGISTRY.register(bus);
        FLUID_REGISTRY.register(bus);
        FLUID_TYPE_REGISTRY.register(bus);
        BLOCK_ENTITY_REGISTRY.register(bus);
        BLOCK_REGISTRY.register(bus);
        ITEM_REGISTRY.register(bus);
        SOUND_REGISTRY.register(bus);
        MENU_REGISTRY.register(bus);
        RECIPE_SERIALIZER_REGISTRY.register(bus);
        RECIPE_TYPE_REGISTRY.register(bus);
        bus.addListener(event -> event.enqueueWork(Menus::registerFactories));
    }

    public static BlockItemAugmentable machineBlockItemOf(Block block) {
        return (BlockItemAugmentable)new BlockItemAugmentable(block, I_PROPERTIES).setNumSlots(() -> ThermalCoreConfig.dynamoAugments).setAugValidator(ThermalAugmentRules.DYNAMO_VALIDATOR).setModId("systeams");
    }

    static <T> ITag<T> modTag(IForgeRegistry<T> registry, String key) {
        return SysteamsRegistry.tag(registry, Systeams.MODRL.m_247449_(key));
    }

    static <T> ITag<T> forgeTag(IForgeRegistry<T> registry, String key) {
        return SysteamsRegistry.tag(registry, new ResourceLocation("forge", key));
    }

    static <T> ITag<T> tag(IForgeRegistry<T> registry, ResourceLocation key) {
        ITagManager manager = registry.tags();
        if (manager == null) {
            throw new IllegalArgumentException("Registry " + registry.getRegistryKey() + " does not support tags");
        }
        return manager.getTag(manager.createTagKey(key));
    }

    public static class Fluids {
        public static final ITag<Fluid> WATER_TAG = SysteamsRegistry.modTag(ForgeRegistries.FLUIDS, "water");
        public static final ITag<Fluid> STEAMISH_TAG = SysteamsRegistry.modTag(ForgeRegistries.FLUIDS, "steamish");
        public static final SteamFluid STEAM = new SteamFluid(FLUID_REGISTRY, FLUID_TYPE_REGISTRY, null, ITEM_REGISTRY, "steam");
        public static final SteamFluid STEAM_2 = new SteamFluid(FLUID_REGISTRY, FLUID_TYPE_REGISTRY, null, ITEM_REGISTRY, "steamier");
        public static final SteamFluid STEAM_3 = new SteamFluid(FLUID_REGISTRY, FLUID_TYPE_REGISTRY, null, ITEM_REGISTRY, "steamiest");
        public static final SteamFluid STEAM_4 = new SteamFluid(FLUID_REGISTRY, FLUID_TYPE_REGISTRY, null, ITEM_REGISTRY, "steamiester");
        public static final SteamFluid STEAM_5 = new PlasmaFluid(FLUID_REGISTRY, FLUID_TYPE_REGISTRY, null, ITEM_REGISTRY, "steamiestest");

        static void init() {
        }
    }

    public static class Blocks {
        public static final RegistryObject<Block> STEAM_DYNAMO = BLOCK_REGISTRY.register("steam_dynamo", () -> new DynamoBlock(B_PROPERTIES, SteamDynamoBlockEntity.class, BlockEntities.STEAM_DYNAMO));

        static void init() {
        }
    }

    public static class Items {
        public static final ItemLike RF_COIL = () -> (Item)ThermalCore.ITEMS.get("thermal:rf_coil");
        public static final ITag<Item> UPGRADE_MAIN = SysteamsRegistry.modTag(ForgeRegistries.ITEMS, "recipe_control/upgrade_main");
        public static final RegistryObject<Item> STEAM_DYNAMO = ITEM_REGISTRY.register("steam_dynamo", () -> SysteamsRegistry.machineBlockItemOf((Block)Blocks.STEAM_DYNAMO.get()));
        public static final RegistryObject<ConversionKitItem> BOILER_PIPE = ITEM_REGISTRY.register("boiler_pipe", () -> new ConversionKitItem(I_PROPERTIES));

        static void init() {
        }
    }

    public static class BlockEntities {
        public static final RegistryObject<BlockEntityType<?>> STEAM_DYNAMO = BLOCK_ENTITY_REGISTRY.register("steam_dynamo", () -> BlockEntityType.Builder.m_155273_(SteamDynamoBlockEntity::new, (Block[])new Block[]{(Block)Blocks.STEAM_DYNAMO.get()}).m_58966_(null));

        static void init() {
        }

        private static <T extends BoilerBlockEntityBase> RegistryObject<BlockEntityType<?>> registerBoiler(String id, BlockEntityType.BlockEntitySupplier<T> BEConstructor, Supplier<Supplier<Block>> block) {
            return BLOCK_ENTITY_REGISTRY.register(id, () -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)BEConstructor, (Block[])new Block[]{(Block)((Supplier)block.get()).get()}).m_58966_(null));
        }
    }

    public static class Menus {
        public static final RegistryObject<MenuType<SteamDynamoMenu>> DYNAMO_STEAM = MENU_REGISTRY.register("steam_dynamo", () -> IForgeMenuType.create(SteamDynamoMenu::new));

        static void init() {
        }

        static void registerFactories() {
            MenuScreens.m_96206_((MenuType)((MenuType)DYNAMO_STEAM.get()), SteamDynamoScreen::new);
            MenuScreens.m_96206_(Boilers.STIRLING.menu(), StirlingBoilerScreen::new);
            MenuScreens.m_96206_(Boilers.MAGMATIC.menu(), MagmaticBoilerScreen::new);
            MenuScreens.m_96206_(Boilers.COMPRESSION.menu(), CompressionBoilerScreen::new);
            MenuScreens.m_96206_(Boilers.NUMISMATIC.menu(), NumismaticBoilerScreen::new);
            MenuScreens.m_96206_(Boilers.LAPIDARY.menu(), LapidaryBoilerScreen::new);
            MenuScreens.m_96206_(Boilers.DISENCHANTMENT.menu(), DisenchantmentBoilerScreen::new);
            MenuScreens.m_96206_(Boilers.GOURMAND.menu(), GourmandBoilerScreen::new);
        }
    }

    public static class Recipes {
        public static final RegistryObject<DynamoFuelSerializer<SteamFuel>> STEAM_SERIALIZER = RECIPE_SERIALIZER_REGISTRY.register("steam", () -> new DynamoFuelSerializer(SteamFuel::new, SteamFuelManager.instance().getDefaultEnergy(), 1000, 200000000));
        public static final RegistryObject<SerializableRecipeType<SteamFuel>> STEAM_TYPE = RECIPE_TYPE_REGISTRY.register("steam", () -> new SerializableRecipeType("systeams", SysteamsRegistry.STEAM_ID));
        public static final RegistryObject<UpgradeShapelessRecipe.Serializer> UPGRADE_SERIALIZER = RECIPE_SERIALIZER_REGISTRY.register("upgrade_shapeless", UpgradeShapelessRecipe.Serializer::new);
        public static final RegistryObject<RecipeType<UpgradeShapelessRecipe>> UPGRADE_TYPE = RECIPE_TYPE_REGISTRY.register("upgrade_shapeless", () -> new RecipeType<UpgradeShapelessRecipe>(){

            public String toString() {
                return "systeams:upgrade_shapeless";
            }
        });
        public static final int MARKER_ENERGY = 10138;
        public static final RegistryObject<MachineRecipeSerializer<BoilingRecipe>> BOILING_SERIALIZER = RECIPE_SERIALIZER_REGISTRY.register("boiling", () -> new MachineRecipeSerializer(BoilingRecipe::new, 10138));
        public static final RegistryObject<SerializableRecipeType<BoilingRecipe>> BOILING_TYPE = RECIPE_TYPE_REGISTRY.register("boiling", () -> new SerializableRecipeType("systeams", SysteamsRegistry.BOILING_ID));

        static void init() {
            ThermalRecipeManagers.registerManager((IManager)SteamFuelManager.instance());
            ThermalRecipeManagers.registerManager((IManager)BoilingRecipeManager.instance());
        }
    }

    public static class Boilers {
        public static final Boiler<StirlingBoilerBlockEntity, StirlingBoilerMenu> STIRLING = new Boiler("stirling_boiler", StirlingBoilerBlockEntity.class, StirlingBoilerBlockEntity::new, StirlingBoilerMenu::new);
        public static final Boiler<MagmaticBoilerBlockEntity, MagmaticBoilerMenu> MAGMATIC = new Boiler("magmatic_boiler", MagmaticBoilerBlockEntity.class, MagmaticBoilerBlockEntity::new, MagmaticBoilerMenu::new);
        public static final Boiler<CompressionBoilerBlockEntity, CompressionBoilerMenu> COMPRESSION = new Boiler("compression_boiler", CompressionBoilerBlockEntity.class, CompressionBoilerBlockEntity::new, CompressionBoilerMenu::new);
        public static final Boiler<NumismaticBoilerBlockEntity, NumismaticBoilerMenu> NUMISMATIC = new Boiler("numismatic_boiler", NumismaticBoilerBlockEntity.class, NumismaticBoilerBlockEntity::new, NumismaticBoilerMenu::new);
        public static final Boiler<LapidaryBoilerBlockEntity, LapidaryBoilerMenu> LAPIDARY = new Boiler("lapidary_boiler", LapidaryBoilerBlockEntity.class, LapidaryBoilerBlockEntity::new, LapidaryBoilerMenu::new);
        public static final Boiler<DisenchantmentBoilerBlockEntity, DisenchantmentBoilerMenu> DISENCHANTMENT = new Boiler("disenchantment_boiler", DisenchantmentBoilerBlockEntity.class, DisenchantmentBoilerBlockEntity::new, DisenchantmentBoilerMenu::new);
        public static final Boiler<GourmandBoilerBlockEntity, GourmandBoilerMenu> GOURMAND = new Boiler("gourmand_boiler", GourmandBoilerBlockEntity.class, GourmandBoilerBlockEntity::new, GourmandBoilerMenu::new);

        static void init() {
        }
    }
}

