/*
 * Decompiled with CFR 0.152.
 */
package chiefarug.mods.systeams;

import chiefarug.mods.systeams.recipe.SteamFuelManager;
import net.minecraftforge.common.ForgeConfigSpec;

public class SysteamsConfig {
    public static final ForgeConfigSpec.DoubleValue STEAM_RATIO_STIRLING;
    public static final ForgeConfigSpec.DoubleValue STEAM_RATIO_MAGMATIC;
    public static final ForgeConfigSpec.DoubleValue STEAM_RATIO_COMPRESSION;
    public static final ForgeConfigSpec.DoubleValue STEAM_RATIO_NUMISMATIC;
    public static final ForgeConfigSpec.DoubleValue STEAM_RATIO_LAPIDARY;
    public static final ForgeConfigSpec.DoubleValue STEAM_RATIO_DISENCHANTMENT;
    public static final ForgeConfigSpec.DoubleValue STEAM_RATIO_GOURMAND;
    public static final ForgeConfigSpec.DoubleValue STEAM_RATIO_PNEUMATIC;
    public static final ForgeConfigSpec.DoubleValue STEAM_RATIO_FROST;
    public static final ForgeConfigSpec.DoubleValue SPEED_STIRLING;
    public static final ForgeConfigSpec.DoubleValue SPEED_MAGMATIC;
    public static final ForgeConfigSpec.DoubleValue SPEED_COMPRESSION;
    public static final ForgeConfigSpec.DoubleValue SPEED_NUMISMATIC;
    public static final ForgeConfigSpec.DoubleValue SPEED_LAPIDARY;
    public static final ForgeConfigSpec.DoubleValue SPEED_DISENCHANTMENT;
    public static final ForgeConfigSpec.DoubleValue SPEED_GOURMAND;
    public static final ForgeConfigSpec.DoubleValue SPEED_PNEUMATIC;
    public static final ForgeConfigSpec.DoubleValue SPEED_FROST;
    public static final ForgeConfigSpec.BooleanValue PNEUMATIC_BOILER_IN_WORLD_CONVERSION;
    public static final ForgeConfigSpec.IntValue STEAM_DYNAMO_POWER;
    public static final ForgeConfigSpec.BooleanValue REPLACE_TOOLTIPS;
    static final ForgeConfigSpec spec;
    private static final double steamRatioDefaultValue = 0.5;
    private static final double steamRatioMin = 0.05;
    private static final double steamRatioMax = 100.0;
    private static final double speedDefaultValue = 2.0;
    private static final double speedMin = 0.05;
    private static final double speedMax = 20.0;

    private static ForgeConfigSpec.DoubleValue steamRatio(ForgeConfigSpec.Builder builder, String name) {
        return builder.defineInRange(name, 0.5, 0.05, 100.0);
    }

    private static ForgeConfigSpec.DoubleValue speed(ForgeConfigSpec.Builder builder, String name) {
        return builder.defineInRange(name, 2.0, 0.05, 20.0);
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment(new String[]{"Systeams Config", "---------------"});
        builder.comment("The multiplier on the steam dynamo's RF/t");
        STEAM_DYNAMO_POWER = builder.defineInRange("steam_dynamo_base_power", 20, SteamFuelManager.instance().getMinPower(), SteamFuelManager.instance().getMaxPower());
        builder.push("Steam Values");
        builder.comment(new String[]{"The number of mb of steam produced per RF of energy usually produced by the same fuel in a dynamo", "Note that this does not affect the steam dynamo's rates. That needs to be adjusted with a datapack"});
        STEAM_RATIO_STIRLING = SysteamsConfig.steamRatio(builder, "stirling");
        STEAM_RATIO_MAGMATIC = SysteamsConfig.steamRatio(builder, "magmatic");
        STEAM_RATIO_COMPRESSION = SysteamsConfig.steamRatio(builder, "compression");
        STEAM_RATIO_NUMISMATIC = SysteamsConfig.steamRatio(builder, "numismatic");
        STEAM_RATIO_LAPIDARY = SysteamsConfig.steamRatio(builder, "lapidary");
        STEAM_RATIO_DISENCHANTMENT = SysteamsConfig.steamRatio(builder, "disenchantment");
        STEAM_RATIO_GOURMAND = SysteamsConfig.steamRatio(builder, "gourmand");
        STEAM_RATIO_PNEUMATIC = SysteamsConfig.steamRatio(builder, "pneumatic");
        STEAM_RATIO_FROST = SysteamsConfig.steamRatio(builder, "frost");
        builder.pop();
        builder.push("Boiler Speed Multipliers");
        builder.comment("The speed multiplier on each boiler's mB/t");
        SPEED_STIRLING = SysteamsConfig.speed(builder, "stirling");
        SPEED_MAGMATIC = SysteamsConfig.speed(builder, "magmatic");
        SPEED_COMPRESSION = SysteamsConfig.speed(builder, "compression");
        SPEED_NUMISMATIC = SysteamsConfig.speed(builder, "numismatic");
        SPEED_LAPIDARY = SysteamsConfig.speed(builder, "lapidary");
        SPEED_DISENCHANTMENT = SysteamsConfig.speed(builder, "disenchantment");
        SPEED_GOURMAND = SysteamsConfig.speed(builder, "gourmand");
        SPEED_PNEUMATIC = SysteamsConfig.speed(builder, "pneumatic");
        SPEED_FROST = SysteamsConfig.speed(builder, "frost");
        builder.pop();
        builder.push("Integration settings");
        PNEUMATIC_BOILER_IN_WORLD_CONVERSION = builder.comment(new String[]{"If you can shift right click a Pneumatic Boiler with an Advanced Pneumatic Tube to convert it to a Pneumatic Dynamo", "This can get annoying when trying to place Advanced Pneumatic Tubes next to boilers"}).define("pneumatic_boiler_conversion_to_dynamo", true);
        builder.pop();
        REPLACE_TOOLTIPS = builder.comment(new String[]{"If the Dynamo in dynamo augment tooltips should be replaced with Dynamo & Boiler", "This doesn't have as much support for translations (it can still be translated with the key info.systeams.augment.type.DynamoBoiler)"}).define("replace_dynamo_augment_tooltips", true);
        spec = builder.build();
    }
}

